<?php
    // Convertir la cadena en un array dividiendo por ', '
    $partesOrigen = explode(', ', $origen);
    $partesDestino = explode(', ', $destino);

    // Tomar solo las dos primeras partes (si existen)
    $origenCorto = implode(', ', array_slice($partesOrigen, 0, 2));
    $destinoCorto = implode(', ', array_slice($partesDestino, 0, 2));
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estado de tu Solicitud</title>
    <style>
        body { font-family: Arial, sans-serif; background-color: #f8f9fa; margin: 0; padding: 20px; }
        .container { max-width: 600px; background: #ffffff; padding: 20px; border-radius: 8px; box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1); margin: auto; }
        .header { text-align: center; color: #333; font-size: 22px; font-weight: bold; }
        .content { margin-top: 20px; font-size: 16px; color: #555; }
        .footer { margin-top: 30px; text-align: center; font-size: 14px; color: #777; }
        .button { display: inline-block; background-color: #007bff; color: #fff; padding: 10px 20px; text-decoration: none; border-radius: 5px; font-size: 16px; margin-top: 20px; }
        .logo { display: flex; justify-content: center; width: 100%;}
    </style>
</head>
<body>
    <div class="container">
        <div class="logo" style="justify-content: center;">
            <img src="https://certificadomisionticutp.com/assets/img/Carpooling-01.png" alt="Logo" width="300">
        </div>

        <div class="content">
            <p>Hola <strong><?php echo e($nombre); ?></strong>,</p>

            <?php if($estado === 'aprobado'): ?>
                <p>Tu solicitud para tomar la ruta de origen <strong><?php echo e($origenCorto); ?></strong> hacia <strong><?php echo e($destinoCorto); ?></strong> ha sido <strong style="color:green;">Aprobada</strong>.</p>
                <p>Haz clic en el siguiente botón para iniciar sesión:</p>
                <a href="<?php echo e(url('/')); ?>"
                style="display: inline-block; background-color: #6b21a8; color: #fff; padding: 10px 20px; text-decoration: none; border-radius: 5px; font-size: 16px; margin-top: 20px;">Acceder</a>
            <?php else: ?>
                <p>Lo sentimos, tu solicitud para tomar la ruta de origen <strong><?php echo e($origenCorto); ?></strong> hacia <strong><?php echo e($destinoCorto); ?></strong> ha sido <strong style="color:red;">Denegada</strong>.</p>
            <?php endif; ?>
        </div>

        <div class="footer">
            <p>&copy; <?php echo e(date('Y')); ?> Carpooling - UTP. Todos los derechos reservados.</p>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\Users\juanm\OneDrive\Documentos\GitHub\carpooling\resources\views/emails/solicitud_rutas.blade.php ENDPATH**/ ?>