<?php

use App\Http\Controllers\Auth\EmailVerificationNotificationController;
use App\Http\Controllers\Auth\EmailVerificationPromptController;
use App\Http\Controllers\EstudianteController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Auth\VerifyEmailController;
use App\Http\Controllers\CalificacionesController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\RoleAssignmentController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\RutasController;
use App\Http\Controllers\SolicitarConductorController;
use App\Http\Controllers\SolicitarViajeController;
use App\Http\Controllers\SolicitudesConductoresController;
use App\Http\Controllers\SolicitudesPasajeroController;
use App\Http\Controllers\SolicitudesRutaController;
use App\Models\Estudiantes;
use App\Models\SolicitudesRuta;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// 🏠 Redirección de la página principal según autenticación
Route::get('/', function () {
    return auth()->check() ? redirect()->route('dashboard') : redirect()->route('login');
});

// 🔐 Rutas de autenticación y registro
Route::resource('register', RegisteredUserController::class);

// 📧 Rutas para verificación de correo
Route::middleware('auth')->group(function () {
    // Mostrar aviso si el correo no está verificado
    Route::get('/verify-email', EmailVerificationPromptController::class)
        ->name('verification.notice');

    // Verificar correo desde el enlace
    Route::get('/verify-email/{id}/{hash}', VerifyEmailController::class)
        ->middleware(['signed', 'throttle:6,1'])
        ->name('verification.verify');

    // Reenviar correo de verificación
    Route::post('/email/verification-notification', [EmailVerificationNotificationController::class, 'store'])
        ->middleware('throttle:6,1')
        ->name('verification.send');
});

// 🛑 Rutas para asignación de roles (usuarios sin rol serán redirigidos aquí)
Route::middleware('auth')->group(function () {
    Route::get('/asignar-rol', [RoleAssignmentController::class, 'form'])->name('asignar.rol');
    Route::post('/asignar-rol', [RoleAssignmentController::class, 'assignRole'])->name('asignar.rol.post');
});

// 📊 Dashboard (Requiere autenticación y verificación)
Route::get('/dashboard', fn () => Inertia::render('Dashboard'))
    ->middleware(['auth', 'verified', 'checkUserRole'])
    ->name('dashboard');


// 🛠️ Grupo con autenticación y verificación de rol asignado
Route::middleware(['auth', 'verified', 'checkUserRole'])->group(function () {
    // ℹ️ Sección de información
    Route::get('/about', fn () => Inertia::render('About'))->name('about');

    // 👤 Perfil de usuario
    Route::prefix('/profile')->group(function () {
        Route::get('/', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::patch('/', [ProfileController::class, 'update'])->name('profile.update');
        Route::delete('/', [ProfileController::class, 'destroy'])->name('profile.destroy');
    });

    // 👥 Gestión de usuarios y roles
    Route::resource('users', UserController::class);
    Route::resource('roles', RoleController::class);

    // 🛑 Rutas
    Route::resource('solicitudes-conductores', SolicitudesConductoresController::class);
    Route::resource('rutas', RutasController::class);
    Route::resource('solicitudes-rutas', SolicitudesRutaController::class);
    Route::resource('solicitar-viaje', SolicitarViajeController::class);
    Route::resource('solicitudes-pasajero', SolicitudesPasajeroController::class);
    Route::resource('calificar', CalificacionesController::class);
    Route::resource('estudiante', EstudianteController::class);
    Route::resource('solicitarconductor', SolicitarConductorController::class);

    Route::put('solicitudes-rutas-aprobar/{id}', [SolicitudesRutaController::class, 'aprobar'])->name('solicitudes-rutas.aprobar');
    Route::put('solicitudes-rutas-rechazar/{id}', [SolicitudesRutaController::class, 'rechazar'])->name('solicitudes-rutas.rechazar');
    Route::put('solicitudes-rutas-finalizar/{id}', [SolicitudesRutaController::class, 'finalizar'])->name('solicitudes-rutas.finalizar');

    Route::put('/rutas/{id}', [RutasController::class, 'update'])->name('rutas.update');
    Route::get('/listcalificacionesconductor', [CalificacionesController::class, 'getCalificarConductores'])->name('calificarconductor.get');
    Route::post('/calificarconductor', [CalificacionesController::class, 'updateCalificacionConductor'])->name('conductorcalificacion.update');


    //📊 rutas dashboard
    Route::get('/resumen', [DashboardController::class, 'resumen'])->name('resumen');
    Route::get('/getrutas', [DashboardController::class, 'rutas'])->name('getrutas');
    Route::get('/getconductores', [DashboardController::class, 'conductores'])->name('getconductores');
    Route::get('/dashboard/metricas', [DashboardController::class, 'getDashboardMetrics'])->name('getDashboardMetrics');
});

// 🛑 Archivo de autenticación (Login, Logout, etc.)
require __DIR__.'/auth.php';
