import "./chunk-WXXH56N5.js";

// node_modules/vue-sweetalert2/dist/vue-sweetalert.es.js
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
var sweetalert2 = { exports: {} };
(function(module, exports) {
  (function(global2, factory) {
    module.exports = factory();
  })(commonjsGlobal, function() {
    const consolePrefix = "SweetAlert2:";
    const uniqueArray = (arr) => {
      const result = [];
      for (let i = 0; i < arr.length; i++) {
        if (result.indexOf(arr[i]) === -1) {
          result.push(arr[i]);
        }
      }
      return result;
    };
    const capitalizeFirstLetter = (str) => str.charAt(0).toUpperCase() + str.slice(1);
    const toArray = (nodeList) => Array.prototype.slice.call(nodeList);
    const warn = (message) => {
      console.warn("".concat(consolePrefix, " ").concat(typeof message === "object" ? message.join(" ") : message));
    };
    const error = (message) => {
      console.error("".concat(consolePrefix, " ").concat(message));
    };
    const previousWarnOnceMessages = [];
    const warnOnce = (message) => {
      if (!previousWarnOnceMessages.includes(message)) {
        previousWarnOnceMessages.push(message);
        warn(message);
      }
    };
    const warnAboutDeprecation = (deprecatedParam, useInstead) => {
      warnOnce('"'.concat(deprecatedParam, '" is deprecated and will be removed in the next major release. Please use "').concat(useInstead, '" instead.'));
    };
    const callIfFunction = (arg) => typeof arg === "function" ? arg() : arg;
    const hasToPromiseFn = (arg) => arg && typeof arg.toPromise === "function";
    const asPromise = (arg) => hasToPromiseFn(arg) ? arg.toPromise() : Promise.resolve(arg);
    const isPromise = (arg) => arg && Promise.resolve(arg) === arg;
    const defaultParams = {
      title: "",
      titleText: "",
      text: "",
      html: "",
      footer: "",
      icon: void 0,
      iconColor: void 0,
      iconHtml: void 0,
      template: void 0,
      toast: false,
      showClass: {
        popup: "swal2-show",
        backdrop: "swal2-backdrop-show",
        icon: "swal2-icon-show"
      },
      hideClass: {
        popup: "swal2-hide",
        backdrop: "swal2-backdrop-hide",
        icon: "swal2-icon-hide"
      },
      customClass: {},
      target: "body",
      color: void 0,
      backdrop: true,
      heightAuto: true,
      allowOutsideClick: true,
      allowEscapeKey: true,
      allowEnterKey: true,
      stopKeydownPropagation: true,
      keydownListenerCapture: false,
      showConfirmButton: true,
      showDenyButton: false,
      showCancelButton: false,
      preConfirm: void 0,
      preDeny: void 0,
      confirmButtonText: "OK",
      confirmButtonAriaLabel: "",
      confirmButtonColor: void 0,
      denyButtonText: "No",
      denyButtonAriaLabel: "",
      denyButtonColor: void 0,
      cancelButtonText: "Cancel",
      cancelButtonAriaLabel: "",
      cancelButtonColor: void 0,
      buttonsStyling: true,
      reverseButtons: false,
      focusConfirm: true,
      focusDeny: false,
      focusCancel: false,
      returnFocus: true,
      showCloseButton: false,
      closeButtonHtml: "&times;",
      closeButtonAriaLabel: "Close this dialog",
      loaderHtml: "",
      showLoaderOnConfirm: false,
      showLoaderOnDeny: false,
      imageUrl: void 0,
      imageWidth: void 0,
      imageHeight: void 0,
      imageAlt: "",
      timer: void 0,
      timerProgressBar: false,
      width: void 0,
      padding: void 0,
      background: void 0,
      input: void 0,
      inputPlaceholder: "",
      inputLabel: "",
      inputValue: "",
      inputOptions: {},
      inputAutoTrim: true,
      inputAttributes: {},
      inputValidator: void 0,
      returnInputValueOnDeny: false,
      validationMessage: void 0,
      grow: false,
      position: "center",
      progressSteps: [],
      currentProgressStep: void 0,
      progressStepsDistance: void 0,
      willOpen: void 0,
      didOpen: void 0,
      didRender: void 0,
      willClose: void 0,
      didClose: void 0,
      didDestroy: void 0,
      scrollbarPadding: true
    };
    const updatableParams = ["allowEscapeKey", "allowOutsideClick", "background", "buttonsStyling", "cancelButtonAriaLabel", "cancelButtonColor", "cancelButtonText", "closeButtonAriaLabel", "closeButtonHtml", "color", "confirmButtonAriaLabel", "confirmButtonColor", "confirmButtonText", "currentProgressStep", "customClass", "denyButtonAriaLabel", "denyButtonColor", "denyButtonText", "didClose", "didDestroy", "footer", "hideClass", "html", "icon", "iconColor", "iconHtml", "imageAlt", "imageHeight", "imageUrl", "imageWidth", "preConfirm", "preDeny", "progressSteps", "returnFocus", "reverseButtons", "showCancelButton", "showCloseButton", "showConfirmButton", "showDenyButton", "text", "title", "titleText", "willClose"];
    const deprecatedParams = {};
    const toastIncompatibleParams = ["allowOutsideClick", "allowEnterKey", "backdrop", "focusConfirm", "focusDeny", "focusCancel", "returnFocus", "heightAuto", "keydownListenerCapture"];
    const isValidParameter = (paramName) => {
      return Object.prototype.hasOwnProperty.call(defaultParams, paramName);
    };
    const isUpdatableParameter = (paramName) => {
      return updatableParams.indexOf(paramName) !== -1;
    };
    const isDeprecatedParameter = (paramName) => {
      return deprecatedParams[paramName];
    };
    const checkIfParamIsValid = (param) => {
      if (!isValidParameter(param)) {
        warn('Unknown parameter "'.concat(param, '"'));
      }
    };
    const checkIfToastParamIsValid = (param) => {
      if (toastIncompatibleParams.includes(param)) {
        warn('The parameter "'.concat(param, '" is incompatible with toasts'));
      }
    };
    const checkIfParamIsDeprecated = (param) => {
      if (isDeprecatedParameter(param)) {
        warnAboutDeprecation(param, isDeprecatedParameter(param));
      }
    };
    const showWarningsForParams = (params) => {
      if (!params.backdrop && params.allowOutsideClick) {
        warn('"allowOutsideClick" parameter requires `backdrop` parameter to be set to `true`');
      }
      for (const param in params) {
        checkIfParamIsValid(param);
        if (params.toast) {
          checkIfToastParamIsValid(param);
        }
        checkIfParamIsDeprecated(param);
      }
    };
    const swalPrefix = "swal2-";
    const prefix = (items) => {
      const result = {};
      for (const i in items) {
        result[items[i]] = swalPrefix + items[i];
      }
      return result;
    };
    const swalClasses = prefix(["container", "shown", "height-auto", "iosfix", "popup", "modal", "no-backdrop", "no-transition", "toast", "toast-shown", "show", "hide", "close", "title", "html-container", "actions", "confirm", "deny", "cancel", "default-outline", "footer", "icon", "icon-content", "image", "input", "file", "range", "select", "radio", "checkbox", "label", "textarea", "inputerror", "input-label", "validation-message", "progress-steps", "active-progress-step", "progress-step", "progress-step-line", "loader", "loading", "styled", "top", "top-start", "top-end", "top-left", "top-right", "center", "center-start", "center-end", "center-left", "center-right", "bottom", "bottom-start", "bottom-end", "bottom-left", "bottom-right", "grow-row", "grow-column", "grow-fullscreen", "rtl", "timer-progress-bar", "timer-progress-bar-container", "scrollbar-measure", "icon-success", "icon-warning", "icon-info", "icon-question", "icon-error"]);
    const iconTypes = prefix(["success", "warning", "info", "question", "error"]);
    const getContainer = () => document.body.querySelector(".".concat(swalClasses.container));
    const elementBySelector = (selectorString) => {
      const container = getContainer();
      return container ? container.querySelector(selectorString) : null;
    };
    const elementByClass = (className) => {
      return elementBySelector(".".concat(className));
    };
    const getPopup = () => elementByClass(swalClasses.popup);
    const getIcon = () => elementByClass(swalClasses.icon);
    const getTitle = () => elementByClass(swalClasses.title);
    const getHtmlContainer = () => elementByClass(swalClasses["html-container"]);
    const getImage = () => elementByClass(swalClasses.image);
    const getProgressSteps = () => elementByClass(swalClasses["progress-steps"]);
    const getValidationMessage = () => elementByClass(swalClasses["validation-message"]);
    const getConfirmButton = () => elementBySelector(".".concat(swalClasses.actions, " .").concat(swalClasses.confirm));
    const getDenyButton = () => elementBySelector(".".concat(swalClasses.actions, " .").concat(swalClasses.deny));
    const getInputLabel = () => elementByClass(swalClasses["input-label"]);
    const getLoader = () => elementBySelector(".".concat(swalClasses.loader));
    const getCancelButton = () => elementBySelector(".".concat(swalClasses.actions, " .").concat(swalClasses.cancel));
    const getActions = () => elementByClass(swalClasses.actions);
    const getFooter = () => elementByClass(swalClasses.footer);
    const getTimerProgressBar = () => elementByClass(swalClasses["timer-progress-bar"]);
    const getCloseButton = () => elementByClass(swalClasses.close);
    const focusable = '\n  a[href],\n  area[href],\n  input:not([disabled]),\n  select:not([disabled]),\n  textarea:not([disabled]),\n  button:not([disabled]),\n  iframe,\n  object,\n  embed,\n  [tabindex="0"],\n  [contenteditable],\n  audio[controls],\n  video[controls],\n  summary\n';
    const getFocusableElements = () => {
      const focusableElementsWithTabindex = toArray(getPopup().querySelectorAll('[tabindex]:not([tabindex="-1"]):not([tabindex="0"])')).sort((a, b) => {
        const tabindexA = parseInt(a.getAttribute("tabindex"));
        const tabindexB = parseInt(b.getAttribute("tabindex"));
        if (tabindexA > tabindexB) {
          return 1;
        } else if (tabindexA < tabindexB) {
          return -1;
        }
        return 0;
      });
      const otherFocusableElements = toArray(getPopup().querySelectorAll(focusable)).filter((el) => el.getAttribute("tabindex") !== "-1");
      return uniqueArray(focusableElementsWithTabindex.concat(otherFocusableElements)).filter((el) => isVisible(el));
    };
    const isModal = () => {
      return !hasClass(document.body, swalClasses["toast-shown"]) && !hasClass(document.body, swalClasses["no-backdrop"]);
    };
    const isToast = () => {
      return getPopup() && hasClass(getPopup(), swalClasses.toast);
    };
    const isLoading = () => {
      return getPopup().hasAttribute("data-loading");
    };
    const states = {
      previousBodyPadding: null
    };
    const setInnerHtml = (elem, html) => {
      elem.textContent = "";
      if (html) {
        const parser = new DOMParser();
        const parsed = parser.parseFromString(html, "text/html");
        toArray(parsed.querySelector("head").childNodes).forEach((child) => {
          elem.appendChild(child);
        });
        toArray(parsed.querySelector("body").childNodes).forEach((child) => {
          elem.appendChild(child);
        });
      }
    };
    const hasClass = (elem, className) => {
      if (!className) {
        return false;
      }
      const classList = className.split(/\s+/);
      for (let i = 0; i < classList.length; i++) {
        if (!elem.classList.contains(classList[i])) {
          return false;
        }
      }
      return true;
    };
    const removeCustomClasses = (elem, params) => {
      toArray(elem.classList).forEach((className) => {
        if (!Object.values(swalClasses).includes(className) && !Object.values(iconTypes).includes(className) && !Object.values(params.showClass).includes(className)) {
          elem.classList.remove(className);
        }
      });
    };
    const applyCustomClass = (elem, params, className) => {
      removeCustomClasses(elem, params);
      if (params.customClass && params.customClass[className]) {
        if (typeof params.customClass[className] !== "string" && !params.customClass[className].forEach) {
          return warn("Invalid type of customClass.".concat(className, '! Expected string or iterable object, got "').concat(typeof params.customClass[className], '"'));
        }
        addClass(elem, params.customClass[className]);
      }
    };
    const getInput = (popup, inputType) => {
      if (!inputType) {
        return null;
      }
      switch (inputType) {
        case "select":
        case "textarea":
        case "file":
          return popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses[inputType]));
        case "checkbox":
          return popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses.checkbox, " input"));
        case "radio":
          return popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses.radio, " input:checked")) || popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses.radio, " input:first-child"));
        case "range":
          return popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses.range, " input"));
        default:
          return popup.querySelector(".".concat(swalClasses.popup, " > .").concat(swalClasses.input));
      }
    };
    const focusInput = (input) => {
      input.focus();
      if (input.type !== "file") {
        const val = input.value;
        input.value = "";
        input.value = val;
      }
    };
    const toggleClass = (target, classList, condition) => {
      if (!target || !classList) {
        return;
      }
      if (typeof classList === "string") {
        classList = classList.split(/\s+/).filter(Boolean);
      }
      classList.forEach((className) => {
        if (Array.isArray(target)) {
          target.forEach((elem) => {
            condition ? elem.classList.add(className) : elem.classList.remove(className);
          });
        } else {
          condition ? target.classList.add(className) : target.classList.remove(className);
        }
      });
    };
    const addClass = (target, classList) => {
      toggleClass(target, classList, true);
    };
    const removeClass = (target, classList) => {
      toggleClass(target, classList, false);
    };
    const getDirectChildByClass = (elem, className) => {
      const childNodes = toArray(elem.childNodes);
      for (let i = 0; i < childNodes.length; i++) {
        if (hasClass(childNodes[i], className)) {
          return childNodes[i];
        }
      }
    };
    const applyNumericalStyle = (elem, property, value) => {
      if (value === "".concat(parseInt(value))) {
        value = parseInt(value);
      }
      if (value || parseInt(value) === 0) {
        elem.style[property] = typeof value === "number" ? "".concat(value, "px") : value;
      } else {
        elem.style.removeProperty(property);
      }
    };
    const show = function(elem) {
      let display = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "flex";
      elem.style.display = display;
    };
    const hide = (elem) => {
      elem.style.display = "none";
    };
    const setStyle = (parent, selector, property, value) => {
      const el = parent.querySelector(selector);
      if (el) {
        el.style[property] = value;
      }
    };
    const toggle = (elem, condition, display) => {
      condition ? show(elem, display) : hide(elem);
    };
    const isVisible = (elem) => !!(elem && (elem.offsetWidth || elem.offsetHeight || elem.getClientRects().length));
    const allButtonsAreHidden = () => !isVisible(getConfirmButton()) && !isVisible(getDenyButton()) && !isVisible(getCancelButton());
    const isScrollable = (elem) => !!(elem.scrollHeight > elem.clientHeight);
    const hasCssAnimation = (elem) => {
      const style = window.getComputedStyle(elem);
      const animDuration = parseFloat(style.getPropertyValue("animation-duration") || "0");
      const transDuration = parseFloat(style.getPropertyValue("transition-duration") || "0");
      return animDuration > 0 || transDuration > 0;
    };
    const animateTimerProgressBar = function(timer) {
      let reset = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
      const timerProgressBar = getTimerProgressBar();
      if (isVisible(timerProgressBar)) {
        if (reset) {
          timerProgressBar.style.transition = "none";
          timerProgressBar.style.width = "100%";
        }
        setTimeout(() => {
          timerProgressBar.style.transition = "width ".concat(timer / 1e3, "s linear");
          timerProgressBar.style.width = "0%";
        }, 10);
      }
    };
    const stopTimerProgressBar = () => {
      const timerProgressBar = getTimerProgressBar();
      const timerProgressBarWidth = parseInt(window.getComputedStyle(timerProgressBar).width);
      timerProgressBar.style.removeProperty("transition");
      timerProgressBar.style.width = "100%";
      const timerProgressBarFullWidth = parseInt(window.getComputedStyle(timerProgressBar).width);
      const timerProgressBarPercent = timerProgressBarWidth / timerProgressBarFullWidth * 100;
      timerProgressBar.style.removeProperty("transition");
      timerProgressBar.style.width = "".concat(timerProgressBarPercent, "%");
    };
    const isNodeEnv = () => typeof window === "undefined" || typeof document === "undefined";
    const RESTORE_FOCUS_TIMEOUT = 100;
    const globalState = {};
    const focusPreviousActiveElement = () => {
      if (globalState.previousActiveElement && globalState.previousActiveElement.focus) {
        globalState.previousActiveElement.focus();
        globalState.previousActiveElement = null;
      } else if (document.body) {
        document.body.focus();
      }
    };
    const restoreActiveElement = (returnFocus) => {
      return new Promise((resolve) => {
        if (!returnFocus) {
          return resolve();
        }
        const x = window.scrollX;
        const y = window.scrollY;
        globalState.restoreFocusTimeout = setTimeout(() => {
          focusPreviousActiveElement();
          resolve();
        }, RESTORE_FOCUS_TIMEOUT);
        window.scrollTo(x, y);
      });
    };
    const sweetHTML = '\n <div aria-labelledby="'.concat(swalClasses.title, '" aria-describedby="').concat(swalClasses["html-container"], '" class="').concat(swalClasses.popup, '" tabindex="-1">\n   <button type="button" class="').concat(swalClasses.close, '"></button>\n   <ul class="').concat(swalClasses["progress-steps"], '"></ul>\n   <div class="').concat(swalClasses.icon, '"></div>\n   <img class="').concat(swalClasses.image, '" />\n   <h2 class="').concat(swalClasses.title, '" id="').concat(swalClasses.title, '"></h2>\n   <div class="').concat(swalClasses["html-container"], '" id="').concat(swalClasses["html-container"], '"></div>\n   <input class="').concat(swalClasses.input, '" />\n   <input type="file" class="').concat(swalClasses.file, '" />\n   <div class="').concat(swalClasses.range, '">\n     <input type="range" />\n     <output></output>\n   </div>\n   <select class="').concat(swalClasses.select, '"></select>\n   <div class="').concat(swalClasses.radio, '"></div>\n   <label for="').concat(swalClasses.checkbox, '" class="').concat(swalClasses.checkbox, '">\n     <input type="checkbox" />\n     <span class="').concat(swalClasses.label, '"></span>\n   </label>\n   <textarea class="').concat(swalClasses.textarea, '"></textarea>\n   <div class="').concat(swalClasses["validation-message"], '" id="').concat(swalClasses["validation-message"], '"></div>\n   <div class="').concat(swalClasses.actions, '">\n     <div class="').concat(swalClasses.loader, '"></div>\n     <button type="button" class="').concat(swalClasses.confirm, '"></button>\n     <button type="button" class="').concat(swalClasses.deny, '"></button>\n     <button type="button" class="').concat(swalClasses.cancel, '"></button>\n   </div>\n   <div class="').concat(swalClasses.footer, '"></div>\n   <div class="').concat(swalClasses["timer-progress-bar-container"], '">\n     <div class="').concat(swalClasses["timer-progress-bar"], '"></div>\n   </div>\n </div>\n').replace(/(^|\n)\s*/g, "");
    const resetOldContainer = () => {
      const oldContainer = getContainer();
      if (!oldContainer) {
        return false;
      }
      oldContainer.remove();
      removeClass([document.documentElement, document.body], [swalClasses["no-backdrop"], swalClasses["toast-shown"], swalClasses["has-column"]]);
      return true;
    };
    const resetValidationMessage = () => {
      globalState.currentInstance.resetValidationMessage();
    };
    const addInputChangeListeners = () => {
      const popup = getPopup();
      const input = getDirectChildByClass(popup, swalClasses.input);
      const file = getDirectChildByClass(popup, swalClasses.file);
      const range = popup.querySelector(".".concat(swalClasses.range, " input"));
      const rangeOutput = popup.querySelector(".".concat(swalClasses.range, " output"));
      const select = getDirectChildByClass(popup, swalClasses.select);
      const checkbox = popup.querySelector(".".concat(swalClasses.checkbox, " input"));
      const textarea = getDirectChildByClass(popup, swalClasses.textarea);
      input.oninput = resetValidationMessage;
      file.onchange = resetValidationMessage;
      select.onchange = resetValidationMessage;
      checkbox.onchange = resetValidationMessage;
      textarea.oninput = resetValidationMessage;
      range.oninput = () => {
        resetValidationMessage();
        rangeOutput.value = range.value;
      };
      range.onchange = () => {
        resetValidationMessage();
        range.nextSibling.value = range.value;
      };
    };
    const getTarget = (target) => typeof target === "string" ? document.querySelector(target) : target;
    const setupAccessibility = (params) => {
      const popup = getPopup();
      popup.setAttribute("role", params.toast ? "alert" : "dialog");
      popup.setAttribute("aria-live", params.toast ? "polite" : "assertive");
      if (!params.toast) {
        popup.setAttribute("aria-modal", "true");
      }
    };
    const setupRTL = (targetElement) => {
      if (window.getComputedStyle(targetElement).direction === "rtl") {
        addClass(getContainer(), swalClasses.rtl);
      }
    };
    const init = (params) => {
      const oldContainerExisted = resetOldContainer();
      if (isNodeEnv()) {
        error("SweetAlert2 requires document to initialize");
        return;
      }
      const container = document.createElement("div");
      container.className = swalClasses.container;
      if (oldContainerExisted) {
        addClass(container, swalClasses["no-transition"]);
      }
      setInnerHtml(container, sweetHTML);
      const targetElement = getTarget(params.target);
      targetElement.appendChild(container);
      setupAccessibility(params);
      setupRTL(targetElement);
      addInputChangeListeners();
    };
    const parseHtmlToContainer = (param, target) => {
      if (param instanceof HTMLElement) {
        target.appendChild(param);
      } else if (typeof param === "object") {
        handleObject(param, target);
      } else if (param) {
        setInnerHtml(target, param);
      }
    };
    const handleObject = (param, target) => {
      if (param.jquery) {
        handleJqueryElem(target, param);
      } else {
        setInnerHtml(target, param.toString());
      }
    };
    const handleJqueryElem = (target, elem) => {
      target.textContent = "";
      if (0 in elem) {
        for (let i = 0; i in elem; i++) {
          target.appendChild(elem[i].cloneNode(true));
        }
      } else {
        target.appendChild(elem.cloneNode(true));
      }
    };
    const animationEndEvent = (() => {
      if (isNodeEnv()) {
        return false;
      }
      const testEl = document.createElement("div");
      const transEndEventNames = {
        WebkitAnimation: "webkitAnimationEnd",
        animation: "animationend"
      };
      for (const i in transEndEventNames) {
        if (Object.prototype.hasOwnProperty.call(transEndEventNames, i) && typeof testEl.style[i] !== "undefined") {
          return transEndEventNames[i];
        }
      }
      return false;
    })();
    const measureScrollbar = () => {
      const scrollDiv = document.createElement("div");
      scrollDiv.className = swalClasses["scrollbar-measure"];
      document.body.appendChild(scrollDiv);
      const scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
      document.body.removeChild(scrollDiv);
      return scrollbarWidth;
    };
    const renderActions = (instance, params) => {
      const actions = getActions();
      const loader = getLoader();
      if (!params.showConfirmButton && !params.showDenyButton && !params.showCancelButton) {
        hide(actions);
      } else {
        show(actions);
      }
      applyCustomClass(actions, params, "actions");
      renderButtons(actions, loader, params);
      setInnerHtml(loader, params.loaderHtml);
      applyCustomClass(loader, params, "loader");
    };
    function renderButtons(actions, loader, params) {
      const confirmButton = getConfirmButton();
      const denyButton = getDenyButton();
      const cancelButton = getCancelButton();
      renderButton(confirmButton, "confirm", params);
      renderButton(denyButton, "deny", params);
      renderButton(cancelButton, "cancel", params);
      handleButtonsStyling(confirmButton, denyButton, cancelButton, params);
      if (params.reverseButtons) {
        if (params.toast) {
          actions.insertBefore(cancelButton, confirmButton);
          actions.insertBefore(denyButton, confirmButton);
        } else {
          actions.insertBefore(cancelButton, loader);
          actions.insertBefore(denyButton, loader);
          actions.insertBefore(confirmButton, loader);
        }
      }
    }
    function handleButtonsStyling(confirmButton, denyButton, cancelButton, params) {
      if (!params.buttonsStyling) {
        return removeClass([confirmButton, denyButton, cancelButton], swalClasses.styled);
      }
      addClass([confirmButton, denyButton, cancelButton], swalClasses.styled);
      if (params.confirmButtonColor) {
        confirmButton.style.backgroundColor = params.confirmButtonColor;
        addClass(confirmButton, swalClasses["default-outline"]);
      }
      if (params.denyButtonColor) {
        denyButton.style.backgroundColor = params.denyButtonColor;
        addClass(denyButton, swalClasses["default-outline"]);
      }
      if (params.cancelButtonColor) {
        cancelButton.style.backgroundColor = params.cancelButtonColor;
        addClass(cancelButton, swalClasses["default-outline"]);
      }
    }
    function renderButton(button, buttonType, params) {
      toggle(button, params["show".concat(capitalizeFirstLetter(buttonType), "Button")], "inline-block");
      setInnerHtml(button, params["".concat(buttonType, "ButtonText")]);
      button.setAttribute("aria-label", params["".concat(buttonType, "ButtonAriaLabel")]);
      button.className = swalClasses[buttonType];
      applyCustomClass(button, params, "".concat(buttonType, "Button"));
      addClass(button, params["".concat(buttonType, "ButtonClass")]);
    }
    function handleBackdropParam(container, backdrop) {
      if (typeof backdrop === "string") {
        container.style.background = backdrop;
      } else if (!backdrop) {
        addClass([document.documentElement, document.body], swalClasses["no-backdrop"]);
      }
    }
    function handlePositionParam(container, position) {
      if (position in swalClasses) {
        addClass(container, swalClasses[position]);
      } else {
        warn('The "position" parameter is not valid, defaulting to "center"');
        addClass(container, swalClasses.center);
      }
    }
    function handleGrowParam(container, grow) {
      if (grow && typeof grow === "string") {
        const growClass = "grow-".concat(grow);
        if (growClass in swalClasses) {
          addClass(container, swalClasses[growClass]);
        }
      }
    }
    const renderContainer = (instance, params) => {
      const container = getContainer();
      if (!container) {
        return;
      }
      handleBackdropParam(container, params.backdrop);
      handlePositionParam(container, params.position);
      handleGrowParam(container, params.grow);
      applyCustomClass(container, params, "container");
    };
    var privateProps = {
      awaitingPromise: /* @__PURE__ */ new WeakMap(),
      promise: /* @__PURE__ */ new WeakMap(),
      innerParams: /* @__PURE__ */ new WeakMap(),
      domCache: /* @__PURE__ */ new WeakMap()
    };
    const inputTypes = ["input", "file", "range", "select", "radio", "checkbox", "textarea"];
    const renderInput = (instance, params) => {
      const popup = getPopup();
      const innerParams = privateProps.innerParams.get(instance);
      const rerender = !innerParams || params.input !== innerParams.input;
      inputTypes.forEach((inputType) => {
        const inputClass = swalClasses[inputType];
        const inputContainer = getDirectChildByClass(popup, inputClass);
        setAttributes(inputType, params.inputAttributes);
        inputContainer.className = inputClass;
        if (rerender) {
          hide(inputContainer);
        }
      });
      if (params.input) {
        if (rerender) {
          showInput(params);
        }
        setCustomClass(params);
      }
    };
    const showInput = (params) => {
      if (!renderInputType[params.input]) {
        return error('Unexpected type of input! Expected "text", "email", "password", "number", "tel", "select", "radio", "checkbox", "textarea", "file" or "url", got "'.concat(params.input, '"'));
      }
      const inputContainer = getInputContainer(params.input);
      const input = renderInputType[params.input](inputContainer, params);
      show(input);
      setTimeout(() => {
        focusInput(input);
      });
    };
    const removeAttributes = (input) => {
      for (let i = 0; i < input.attributes.length; i++) {
        const attrName = input.attributes[i].name;
        if (!["type", "value", "style"].includes(attrName)) {
          input.removeAttribute(attrName);
        }
      }
    };
    const setAttributes = (inputType, inputAttributes) => {
      const input = getInput(getPopup(), inputType);
      if (!input) {
        return;
      }
      removeAttributes(input);
      for (const attr in inputAttributes) {
        input.setAttribute(attr, inputAttributes[attr]);
      }
    };
    const setCustomClass = (params) => {
      const inputContainer = getInputContainer(params.input);
      if (params.customClass) {
        addClass(inputContainer, params.customClass.input);
      }
    };
    const setInputPlaceholder = (input, params) => {
      if (!input.placeholder || params.inputPlaceholder) {
        input.placeholder = params.inputPlaceholder;
      }
    };
    const setInputLabel = (input, prependTo, params) => {
      if (params.inputLabel) {
        input.id = swalClasses.input;
        const label = document.createElement("label");
        const labelClass = swalClasses["input-label"];
        label.setAttribute("for", input.id);
        label.className = labelClass;
        addClass(label, params.customClass.inputLabel);
        label.innerText = params.inputLabel;
        prependTo.insertAdjacentElement("beforebegin", label);
      }
    };
    const getInputContainer = (inputType) => {
      const inputClass = swalClasses[inputType] ? swalClasses[inputType] : swalClasses.input;
      return getDirectChildByClass(getPopup(), inputClass);
    };
    const renderInputType = {};
    renderInputType.text = renderInputType.email = renderInputType.password = renderInputType.number = renderInputType.tel = renderInputType.url = (input, params) => {
      if (typeof params.inputValue === "string" || typeof params.inputValue === "number") {
        input.value = params.inputValue;
      } else if (!isPromise(params.inputValue)) {
        warn('Unexpected type of inputValue! Expected "string", "number" or "Promise", got "'.concat(typeof params.inputValue, '"'));
      }
      setInputLabel(input, input, params);
      setInputPlaceholder(input, params);
      input.type = params.input;
      return input;
    };
    renderInputType.file = (input, params) => {
      setInputLabel(input, input, params);
      setInputPlaceholder(input, params);
      return input;
    };
    renderInputType.range = (range, params) => {
      const rangeInput = range.querySelector("input");
      const rangeOutput = range.querySelector("output");
      rangeInput.value = params.inputValue;
      rangeInput.type = params.input;
      rangeOutput.value = params.inputValue;
      setInputLabel(rangeInput, range, params);
      return range;
    };
    renderInputType.select = (select, params) => {
      select.textContent = "";
      if (params.inputPlaceholder) {
        const placeholder = document.createElement("option");
        setInnerHtml(placeholder, params.inputPlaceholder);
        placeholder.value = "";
        placeholder.disabled = true;
        placeholder.selected = true;
        select.appendChild(placeholder);
      }
      setInputLabel(select, select, params);
      return select;
    };
    renderInputType.radio = (radio) => {
      radio.textContent = "";
      return radio;
    };
    renderInputType.checkbox = (checkboxContainer, params) => {
      const checkbox = getInput(getPopup(), "checkbox");
      checkbox.value = "1";
      checkbox.id = swalClasses.checkbox;
      checkbox.checked = Boolean(params.inputValue);
      const label = checkboxContainer.querySelector("span");
      setInnerHtml(label, params.inputPlaceholder);
      return checkboxContainer;
    };
    renderInputType.textarea = (textarea, params) => {
      textarea.value = params.inputValue;
      setInputPlaceholder(textarea, params);
      setInputLabel(textarea, textarea, params);
      const getMargin = (el) => parseInt(window.getComputedStyle(el).marginLeft) + parseInt(window.getComputedStyle(el).marginRight);
      setTimeout(() => {
        if ("MutationObserver" in window) {
          const initialPopupWidth = parseInt(window.getComputedStyle(getPopup()).width);
          const textareaResizeHandler = () => {
            const textareaWidth = textarea.offsetWidth + getMargin(textarea);
            if (textareaWidth > initialPopupWidth) {
              getPopup().style.width = "".concat(textareaWidth, "px");
            } else {
              getPopup().style.width = null;
            }
          };
          new MutationObserver(textareaResizeHandler).observe(textarea, {
            attributes: true,
            attributeFilter: ["style"]
          });
        }
      });
      return textarea;
    };
    const renderContent = (instance, params) => {
      const htmlContainer = getHtmlContainer();
      applyCustomClass(htmlContainer, params, "htmlContainer");
      if (params.html) {
        parseHtmlToContainer(params.html, htmlContainer);
        show(htmlContainer, "block");
      } else if (params.text) {
        htmlContainer.textContent = params.text;
        show(htmlContainer, "block");
      } else {
        hide(htmlContainer);
      }
      renderInput(instance, params);
    };
    const renderFooter = (instance, params) => {
      const footer = getFooter();
      toggle(footer, params.footer);
      if (params.footer) {
        parseHtmlToContainer(params.footer, footer);
      }
      applyCustomClass(footer, params, "footer");
    };
    const renderCloseButton = (instance, params) => {
      const closeButton = getCloseButton();
      setInnerHtml(closeButton, params.closeButtonHtml);
      applyCustomClass(closeButton, params, "closeButton");
      toggle(closeButton, params.showCloseButton);
      closeButton.setAttribute("aria-label", params.closeButtonAriaLabel);
    };
    const renderIcon = (instance, params) => {
      const innerParams = privateProps.innerParams.get(instance);
      const icon = getIcon();
      if (innerParams && params.icon === innerParams.icon) {
        setContent(icon, params);
        applyStyles(icon, params);
        return;
      }
      if (!params.icon && !params.iconHtml) {
        return hide(icon);
      }
      if (params.icon && Object.keys(iconTypes).indexOf(params.icon) === -1) {
        error('Unknown icon! Expected "success", "error", "warning", "info" or "question", got "'.concat(params.icon, '"'));
        return hide(icon);
      }
      show(icon);
      setContent(icon, params);
      applyStyles(icon, params);
      addClass(icon, params.showClass.icon);
    };
    const applyStyles = (icon, params) => {
      for (const iconType in iconTypes) {
        if (params.icon !== iconType) {
          removeClass(icon, iconTypes[iconType]);
        }
      }
      addClass(icon, iconTypes[params.icon]);
      setColor(icon, params);
      adjustSuccessIconBackgroundColor();
      applyCustomClass(icon, params, "icon");
    };
    const adjustSuccessIconBackgroundColor = () => {
      const popup = getPopup();
      const popupBackgroundColor = window.getComputedStyle(popup).getPropertyValue("background-color");
      const successIconParts = popup.querySelectorAll("[class^=swal2-success-circular-line], .swal2-success-fix");
      for (let i = 0; i < successIconParts.length; i++) {
        successIconParts[i].style.backgroundColor = popupBackgroundColor;
      }
    };
    const successIconHtml = '\n  <div class="swal2-success-circular-line-left"></div>\n  <span class="swal2-success-line-tip"></span> <span class="swal2-success-line-long"></span>\n  <div class="swal2-success-ring"></div> <div class="swal2-success-fix"></div>\n  <div class="swal2-success-circular-line-right"></div>\n';
    const errorIconHtml = '\n  <span class="swal2-x-mark">\n    <span class="swal2-x-mark-line-left"></span>\n    <span class="swal2-x-mark-line-right"></span>\n  </span>\n';
    const setContent = (icon, params) => {
      icon.textContent = "";
      if (params.iconHtml) {
        setInnerHtml(icon, iconContent(params.iconHtml));
      } else if (params.icon === "success") {
        setInnerHtml(icon, successIconHtml);
      } else if (params.icon === "error") {
        setInnerHtml(icon, errorIconHtml);
      } else {
        const defaultIconHtml = {
          question: "?",
          warning: "!",
          info: "i"
        };
        setInnerHtml(icon, iconContent(defaultIconHtml[params.icon]));
      }
    };
    const setColor = (icon, params) => {
      if (!params.iconColor) {
        return;
      }
      icon.style.color = params.iconColor;
      icon.style.borderColor = params.iconColor;
      for (const sel of [".swal2-success-line-tip", ".swal2-success-line-long", ".swal2-x-mark-line-left", ".swal2-x-mark-line-right"]) {
        setStyle(icon, sel, "backgroundColor", params.iconColor);
      }
      setStyle(icon, ".swal2-success-ring", "borderColor", params.iconColor);
    };
    const iconContent = (content) => '<div class="'.concat(swalClasses["icon-content"], '">').concat(content, "</div>");
    const renderImage = (instance, params) => {
      const image = getImage();
      if (!params.imageUrl) {
        return hide(image);
      }
      show(image, "");
      image.setAttribute("src", params.imageUrl);
      image.setAttribute("alt", params.imageAlt);
      applyNumericalStyle(image, "width", params.imageWidth);
      applyNumericalStyle(image, "height", params.imageHeight);
      image.className = swalClasses.image;
      applyCustomClass(image, params, "image");
    };
    const createStepElement = (step) => {
      const stepEl = document.createElement("li");
      addClass(stepEl, swalClasses["progress-step"]);
      setInnerHtml(stepEl, step);
      return stepEl;
    };
    const createLineElement = (params) => {
      const lineEl = document.createElement("li");
      addClass(lineEl, swalClasses["progress-step-line"]);
      if (params.progressStepsDistance) {
        lineEl.style.width = params.progressStepsDistance;
      }
      return lineEl;
    };
    const renderProgressSteps = (instance, params) => {
      const progressStepsContainer = getProgressSteps();
      if (!params.progressSteps || params.progressSteps.length === 0) {
        return hide(progressStepsContainer);
      }
      show(progressStepsContainer);
      progressStepsContainer.textContent = "";
      if (params.currentProgressStep >= params.progressSteps.length) {
        warn("Invalid currentProgressStep parameter, it should be less than progressSteps.length (currentProgressStep like JS arrays starts from 0)");
      }
      params.progressSteps.forEach((step, index) => {
        const stepEl = createStepElement(step);
        progressStepsContainer.appendChild(stepEl);
        if (index === params.currentProgressStep) {
          addClass(stepEl, swalClasses["active-progress-step"]);
        }
        if (index !== params.progressSteps.length - 1) {
          const lineEl = createLineElement(params);
          progressStepsContainer.appendChild(lineEl);
        }
      });
    };
    const renderTitle = (instance, params) => {
      const title = getTitle();
      toggle(title, params.title || params.titleText, "block");
      if (params.title) {
        parseHtmlToContainer(params.title, title);
      }
      if (params.titleText) {
        title.innerText = params.titleText;
      }
      applyCustomClass(title, params, "title");
    };
    const renderPopup = (instance, params) => {
      const container = getContainer();
      const popup = getPopup();
      if (params.toast) {
        applyNumericalStyle(container, "width", params.width);
        popup.style.width = "100%";
        popup.insertBefore(getLoader(), getIcon());
      } else {
        applyNumericalStyle(popup, "width", params.width);
      }
      applyNumericalStyle(popup, "padding", params.padding);
      if (params.color) {
        popup.style.color = params.color;
      }
      if (params.background) {
        popup.style.background = params.background;
      }
      hide(getValidationMessage());
      addClasses(popup, params);
    };
    const addClasses = (popup, params) => {
      popup.className = "".concat(swalClasses.popup, " ").concat(isVisible(popup) ? params.showClass.popup : "");
      if (params.toast) {
        addClass([document.documentElement, document.body], swalClasses["toast-shown"]);
        addClass(popup, swalClasses.toast);
      } else {
        addClass(popup, swalClasses.modal);
      }
      applyCustomClass(popup, params, "popup");
      if (typeof params.customClass === "string") {
        addClass(popup, params.customClass);
      }
      if (params.icon) {
        addClass(popup, swalClasses["icon-".concat(params.icon)]);
      }
    };
    const render = (instance, params) => {
      renderPopup(instance, params);
      renderContainer(instance, params);
      renderProgressSteps(instance, params);
      renderIcon(instance, params);
      renderImage(instance, params);
      renderTitle(instance, params);
      renderCloseButton(instance, params);
      renderContent(instance, params);
      renderActions(instance, params);
      renderFooter(instance, params);
      if (typeof params.didRender === "function") {
        params.didRender(getPopup());
      }
    };
    const DismissReason = Object.freeze({
      cancel: "cancel",
      backdrop: "backdrop",
      close: "close",
      esc: "esc",
      timer: "timer"
    });
    const setAriaHidden = () => {
      const bodyChildren = toArray(document.body.children);
      bodyChildren.forEach((el) => {
        if (el === getContainer() || el.contains(getContainer())) {
          return;
        }
        if (el.hasAttribute("aria-hidden")) {
          el.setAttribute("data-previous-aria-hidden", el.getAttribute("aria-hidden"));
        }
        el.setAttribute("aria-hidden", "true");
      });
    };
    const unsetAriaHidden = () => {
      const bodyChildren = toArray(document.body.children);
      bodyChildren.forEach((el) => {
        if (el.hasAttribute("data-previous-aria-hidden")) {
          el.setAttribute("aria-hidden", el.getAttribute("data-previous-aria-hidden"));
          el.removeAttribute("data-previous-aria-hidden");
        } else {
          el.removeAttribute("aria-hidden");
        }
      });
    };
    const swalStringParams = ["swal-title", "swal-html", "swal-footer"];
    const getTemplateParams = (params) => {
      const template = typeof params.template === "string" ? document.querySelector(params.template) : params.template;
      if (!template) {
        return {};
      }
      const templateContent = template.content;
      showWarningsForElements(templateContent);
      const result = Object.assign(getSwalParams(templateContent), getSwalButtons(templateContent), getSwalImage(templateContent), getSwalIcon(templateContent), getSwalInput(templateContent), getSwalStringParams(templateContent, swalStringParams));
      return result;
    };
    const getSwalParams = (templateContent) => {
      const result = {};
      toArray(templateContent.querySelectorAll("swal-param")).forEach((param) => {
        showWarningsForAttributes(param, ["name", "value"]);
        const paramName = param.getAttribute("name");
        const value = param.getAttribute("value");
        if (typeof defaultParams[paramName] === "boolean" && value === "false") {
          result[paramName] = false;
        }
        if (typeof defaultParams[paramName] === "object") {
          result[paramName] = JSON.parse(value);
        }
      });
      return result;
    };
    const getSwalButtons = (templateContent) => {
      const result = {};
      toArray(templateContent.querySelectorAll("swal-button")).forEach((button) => {
        showWarningsForAttributes(button, ["type", "color", "aria-label"]);
        const type = button.getAttribute("type");
        result["".concat(type, "ButtonText")] = button.innerHTML;
        result["show".concat(capitalizeFirstLetter(type), "Button")] = true;
        if (button.hasAttribute("color")) {
          result["".concat(type, "ButtonColor")] = button.getAttribute("color");
        }
        if (button.hasAttribute("aria-label")) {
          result["".concat(type, "ButtonAriaLabel")] = button.getAttribute("aria-label");
        }
      });
      return result;
    };
    const getSwalImage = (templateContent) => {
      const result = {};
      const image = templateContent.querySelector("swal-image");
      if (image) {
        showWarningsForAttributes(image, ["src", "width", "height", "alt"]);
        if (image.hasAttribute("src")) {
          result.imageUrl = image.getAttribute("src");
        }
        if (image.hasAttribute("width")) {
          result.imageWidth = image.getAttribute("width");
        }
        if (image.hasAttribute("height")) {
          result.imageHeight = image.getAttribute("height");
        }
        if (image.hasAttribute("alt")) {
          result.imageAlt = image.getAttribute("alt");
        }
      }
      return result;
    };
    const getSwalIcon = (templateContent) => {
      const result = {};
      const icon = templateContent.querySelector("swal-icon");
      if (icon) {
        showWarningsForAttributes(icon, ["type", "color"]);
        if (icon.hasAttribute("type")) {
          result.icon = icon.getAttribute("type");
        }
        if (icon.hasAttribute("color")) {
          result.iconColor = icon.getAttribute("color");
        }
        result.iconHtml = icon.innerHTML;
      }
      return result;
    };
    const getSwalInput = (templateContent) => {
      const result = {};
      const input = templateContent.querySelector("swal-input");
      if (input) {
        showWarningsForAttributes(input, ["type", "label", "placeholder", "value"]);
        result.input = input.getAttribute("type") || "text";
        if (input.hasAttribute("label")) {
          result.inputLabel = input.getAttribute("label");
        }
        if (input.hasAttribute("placeholder")) {
          result.inputPlaceholder = input.getAttribute("placeholder");
        }
        if (input.hasAttribute("value")) {
          result.inputValue = input.getAttribute("value");
        }
      }
      const inputOptions = templateContent.querySelectorAll("swal-input-option");
      if (inputOptions.length) {
        result.inputOptions = {};
        toArray(inputOptions).forEach((option) => {
          showWarningsForAttributes(option, ["value"]);
          const optionValue = option.getAttribute("value");
          const optionName = option.innerHTML;
          result.inputOptions[optionValue] = optionName;
        });
      }
      return result;
    };
    const getSwalStringParams = (templateContent, paramNames) => {
      const result = {};
      for (const i in paramNames) {
        const paramName = paramNames[i];
        const tag = templateContent.querySelector(paramName);
        if (tag) {
          showWarningsForAttributes(tag, []);
          result[paramName.replace(/^swal-/, "")] = tag.innerHTML.trim();
        }
      }
      return result;
    };
    const showWarningsForElements = (templateContent) => {
      const allowedElements = swalStringParams.concat(["swal-param", "swal-button", "swal-image", "swal-icon", "swal-input", "swal-input-option"]);
      toArray(templateContent.children).forEach((el) => {
        const tagName = el.tagName.toLowerCase();
        if (allowedElements.indexOf(tagName) === -1) {
          warn("Unrecognized element <".concat(tagName, ">"));
        }
      });
    };
    const showWarningsForAttributes = (el, allowedAttributes) => {
      toArray(el.attributes).forEach((attribute) => {
        if (allowedAttributes.indexOf(attribute.name) === -1) {
          warn(['Unrecognized attribute "'.concat(attribute.name, '" on <').concat(el.tagName.toLowerCase(), ">."), "".concat(allowedAttributes.length ? "Allowed attributes are: ".concat(allowedAttributes.join(", ")) : "To set the value, use HTML within the element.")]);
        }
      });
    };
    var defaultInputValidators = {
      email: (string, validationMessage) => {
        return /^[a-zA-Z0-9.+_-]+@[a-zA-Z0-9.-]+\.[a-zA-Z0-9-]{2,24}$/.test(string) ? Promise.resolve() : Promise.resolve(validationMessage || "Invalid email address");
      },
      url: (string, validationMessage) => {
        return /^https?:\/\/(www\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\.[a-z]{2,63}\b([-a-zA-Z0-9@:%_+.~#?&/=]*)$/.test(string) ? Promise.resolve() : Promise.resolve(validationMessage || "Invalid URL");
      }
    };
    function setDefaultInputValidators(params) {
      if (!params.inputValidator) {
        Object.keys(defaultInputValidators).forEach((key) => {
          if (params.input === key) {
            params.inputValidator = defaultInputValidators[key];
          }
        });
      }
    }
    function validateCustomTargetElement(params) {
      if (!params.target || typeof params.target === "string" && !document.querySelector(params.target) || typeof params.target !== "string" && !params.target.appendChild) {
        warn('Target parameter is not valid, defaulting to "body"');
        params.target = "body";
      }
    }
    function setParameters(params) {
      setDefaultInputValidators(params);
      if (params.showLoaderOnConfirm && !params.preConfirm) {
        warn("showLoaderOnConfirm is set to true, but preConfirm is not defined.\nshowLoaderOnConfirm should be used together with preConfirm, see usage example:\nhttps://sweetalert2.github.io/#ajax-request");
      }
      validateCustomTargetElement(params);
      if (typeof params.title === "string") {
        params.title = params.title.split("\n").join("<br />");
      }
      init(params);
    }
    class Timer {
      constructor(callback, delay) {
        this.callback = callback;
        this.remaining = delay;
        this.running = false;
        this.start();
      }
      start() {
        if (!this.running) {
          this.running = true;
          this.started = /* @__PURE__ */ new Date();
          this.id = setTimeout(this.callback, this.remaining);
        }
        return this.remaining;
      }
      stop() {
        if (this.running) {
          this.running = false;
          clearTimeout(this.id);
          this.remaining -= (/* @__PURE__ */ new Date()).getTime() - this.started.getTime();
        }
        return this.remaining;
      }
      increase(n) {
        const running = this.running;
        if (running) {
          this.stop();
        }
        this.remaining += n;
        if (running) {
          this.start();
        }
        return this.remaining;
      }
      getTimerLeft() {
        if (this.running) {
          this.stop();
          this.start();
        }
        return this.remaining;
      }
      isRunning() {
        return this.running;
      }
    }
    const fixScrollbar = () => {
      if (states.previousBodyPadding !== null) {
        return;
      }
      if (document.body.scrollHeight > window.innerHeight) {
        states.previousBodyPadding = parseInt(window.getComputedStyle(document.body).getPropertyValue("padding-right"));
        document.body.style.paddingRight = "".concat(states.previousBodyPadding + measureScrollbar(), "px");
      }
    };
    const undoScrollbar = () => {
      if (states.previousBodyPadding !== null) {
        document.body.style.paddingRight = "".concat(states.previousBodyPadding, "px");
        states.previousBodyPadding = null;
      }
    };
    const iOSfix = () => {
      const iOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream || navigator.platform === "MacIntel" && navigator.maxTouchPoints > 1;
      if (iOS && !hasClass(document.body, swalClasses.iosfix)) {
        const offset = document.body.scrollTop;
        document.body.style.top = "".concat(offset * -1, "px");
        addClass(document.body, swalClasses.iosfix);
        lockBodyScroll();
        addBottomPaddingForTallPopups();
      }
    };
    const addBottomPaddingForTallPopups = () => {
      const ua = navigator.userAgent;
      const iOS = !!ua.match(/iPad/i) || !!ua.match(/iPhone/i);
      const webkit = !!ua.match(/WebKit/i);
      const iOSSafari = iOS && webkit && !ua.match(/CriOS/i);
      if (iOSSafari) {
        const bottomPanelHeight = 44;
        if (getPopup().scrollHeight > window.innerHeight - bottomPanelHeight) {
          getContainer().style.paddingBottom = "".concat(bottomPanelHeight, "px");
        }
      }
    };
    const lockBodyScroll = () => {
      const container = getContainer();
      let preventTouchMove;
      container.ontouchstart = (e) => {
        preventTouchMove = shouldPreventTouchMove(e);
      };
      container.ontouchmove = (e) => {
        if (preventTouchMove) {
          e.preventDefault();
          e.stopPropagation();
        }
      };
    };
    const shouldPreventTouchMove = (event) => {
      const target = event.target;
      const container = getContainer();
      if (isStylus(event) || isZoom(event)) {
        return false;
      }
      if (target === container) {
        return true;
      }
      if (!isScrollable(container) && target.tagName !== "INPUT" && target.tagName !== "TEXTAREA" && !(isScrollable(getHtmlContainer()) && getHtmlContainer().contains(target))) {
        return true;
      }
      return false;
    };
    const isStylus = (event) => {
      return event.touches && event.touches.length && event.touches[0].touchType === "stylus";
    };
    const isZoom = (event) => {
      return event.touches && event.touches.length > 1;
    };
    const undoIOSfix = () => {
      if (hasClass(document.body, swalClasses.iosfix)) {
        const offset = parseInt(document.body.style.top, 10);
        removeClass(document.body, swalClasses.iosfix);
        document.body.style.top = "";
        document.body.scrollTop = offset * -1;
      }
    };
    const SHOW_CLASS_TIMEOUT = 10;
    const openPopup = (params) => {
      const container = getContainer();
      const popup = getPopup();
      if (typeof params.willOpen === "function") {
        params.willOpen(popup);
      }
      const bodyStyles = window.getComputedStyle(document.body);
      const initialBodyOverflow = bodyStyles.overflowY;
      addClasses$1(container, popup, params);
      setTimeout(() => {
        setScrollingVisibility(container, popup);
      }, SHOW_CLASS_TIMEOUT);
      if (isModal()) {
        fixScrollContainer(container, params.scrollbarPadding, initialBodyOverflow);
        setAriaHidden();
      }
      if (!isToast() && !globalState.previousActiveElement) {
        globalState.previousActiveElement = document.activeElement;
      }
      if (typeof params.didOpen === "function") {
        setTimeout(() => params.didOpen(popup));
      }
      removeClass(container, swalClasses["no-transition"]);
    };
    const swalOpenAnimationFinished = (event) => {
      const popup = getPopup();
      if (event.target !== popup) {
        return;
      }
      const container = getContainer();
      popup.removeEventListener(animationEndEvent, swalOpenAnimationFinished);
      container.style.overflowY = "auto";
    };
    const setScrollingVisibility = (container, popup) => {
      if (animationEndEvent && hasCssAnimation(popup)) {
        container.style.overflowY = "hidden";
        popup.addEventListener(animationEndEvent, swalOpenAnimationFinished);
      } else {
        container.style.overflowY = "auto";
      }
    };
    const fixScrollContainer = (container, scrollbarPadding, initialBodyOverflow) => {
      iOSfix();
      if (scrollbarPadding && initialBodyOverflow !== "hidden") {
        fixScrollbar();
      }
      setTimeout(() => {
        container.scrollTop = 0;
      });
    };
    const addClasses$1 = (container, popup, params) => {
      addClass(container, params.showClass.backdrop);
      popup.style.setProperty("opacity", "0", "important");
      show(popup, "grid");
      setTimeout(() => {
        addClass(popup, params.showClass.popup);
        popup.style.removeProperty("opacity");
      }, SHOW_CLASS_TIMEOUT);
      addClass([document.documentElement, document.body], swalClasses.shown);
      if (params.heightAuto && params.backdrop && !params.toast) {
        addClass([document.documentElement, document.body], swalClasses["height-auto"]);
      }
    };
    const showLoading = (buttonToReplace) => {
      let popup = getPopup();
      if (!popup) {
        new Swal2();
      }
      popup = getPopup();
      const loader = getLoader();
      if (isToast()) {
        hide(getIcon());
      } else {
        replaceButton(popup, buttonToReplace);
      }
      show(loader);
      popup.setAttribute("data-loading", true);
      popup.setAttribute("aria-busy", true);
      popup.focus();
    };
    const replaceButton = (popup, buttonToReplace) => {
      const actions = getActions();
      const loader = getLoader();
      if (!buttonToReplace && isVisible(getConfirmButton())) {
        buttonToReplace = getConfirmButton();
      }
      show(actions);
      if (buttonToReplace) {
        hide(buttonToReplace);
        loader.setAttribute("data-button-to-replace", buttonToReplace.className);
      }
      loader.parentNode.insertBefore(loader, buttonToReplace);
      addClass([popup, actions], swalClasses.loading);
    };
    const handleInputOptionsAndValue = (instance, params) => {
      if (params.input === "select" || params.input === "radio") {
        handleInputOptions(instance, params);
      } else if (["text", "email", "number", "tel", "textarea"].includes(params.input) && (hasToPromiseFn(params.inputValue) || isPromise(params.inputValue))) {
        showLoading(getConfirmButton());
        handleInputValue(instance, params);
      }
    };
    const getInputValue = (instance, innerParams) => {
      const input = instance.getInput();
      if (!input) {
        return null;
      }
      switch (innerParams.input) {
        case "checkbox":
          return getCheckboxValue(input);
        case "radio":
          return getRadioValue(input);
        case "file":
          return getFileValue(input);
        default:
          return innerParams.inputAutoTrim ? input.value.trim() : input.value;
      }
    };
    const getCheckboxValue = (input) => input.checked ? 1 : 0;
    const getRadioValue = (input) => input.checked ? input.value : null;
    const getFileValue = (input) => input.files.length ? input.getAttribute("multiple") !== null ? input.files : input.files[0] : null;
    const handleInputOptions = (instance, params) => {
      const popup = getPopup();
      const processInputOptions = (inputOptions) => populateInputOptions[params.input](popup, formatInputOptions(inputOptions), params);
      if (hasToPromiseFn(params.inputOptions) || isPromise(params.inputOptions)) {
        showLoading(getConfirmButton());
        asPromise(params.inputOptions).then((inputOptions) => {
          instance.hideLoading();
          processInputOptions(inputOptions);
        });
      } else if (typeof params.inputOptions === "object") {
        processInputOptions(params.inputOptions);
      } else {
        error("Unexpected type of inputOptions! Expected object, Map or Promise, got ".concat(typeof params.inputOptions));
      }
    };
    const handleInputValue = (instance, params) => {
      const input = instance.getInput();
      hide(input);
      asPromise(params.inputValue).then((inputValue) => {
        input.value = params.input === "number" ? parseFloat(inputValue) || 0 : "".concat(inputValue);
        show(input);
        input.focus();
        instance.hideLoading();
      }).catch((err) => {
        error("Error in inputValue promise: ".concat(err));
        input.value = "";
        show(input);
        input.focus();
        instance.hideLoading();
      });
    };
    const populateInputOptions = {
      select: (popup, inputOptions, params) => {
        const select = getDirectChildByClass(popup, swalClasses.select);
        const renderOption = (parent, optionLabel, optionValue) => {
          const option = document.createElement("option");
          option.value = optionValue;
          setInnerHtml(option, optionLabel);
          option.selected = isSelected(optionValue, params.inputValue);
          parent.appendChild(option);
        };
        inputOptions.forEach((inputOption) => {
          const optionValue = inputOption[0];
          const optionLabel = inputOption[1];
          if (Array.isArray(optionLabel)) {
            const optgroup = document.createElement("optgroup");
            optgroup.label = optionValue;
            optgroup.disabled = false;
            select.appendChild(optgroup);
            optionLabel.forEach((o) => renderOption(optgroup, o[1], o[0]));
          } else {
            renderOption(select, optionLabel, optionValue);
          }
        });
        select.focus();
      },
      radio: (popup, inputOptions, params) => {
        const radio = getDirectChildByClass(popup, swalClasses.radio);
        inputOptions.forEach((inputOption) => {
          const radioValue = inputOption[0];
          const radioLabel = inputOption[1];
          const radioInput = document.createElement("input");
          const radioLabelElement = document.createElement("label");
          radioInput.type = "radio";
          radioInput.name = swalClasses.radio;
          radioInput.value = radioValue;
          if (isSelected(radioValue, params.inputValue)) {
            radioInput.checked = true;
          }
          const label = document.createElement("span");
          setInnerHtml(label, radioLabel);
          label.className = swalClasses.label;
          radioLabelElement.appendChild(radioInput);
          radioLabelElement.appendChild(label);
          radio.appendChild(radioLabelElement);
        });
        const radios = radio.querySelectorAll("input");
        if (radios.length) {
          radios[0].focus();
        }
      }
    };
    const formatInputOptions = (inputOptions) => {
      const result = [];
      if (typeof Map !== "undefined" && inputOptions instanceof Map) {
        inputOptions.forEach((value, key) => {
          let valueFormatted = value;
          if (typeof valueFormatted === "object") {
            valueFormatted = formatInputOptions(valueFormatted);
          }
          result.push([key, valueFormatted]);
        });
      } else {
        Object.keys(inputOptions).forEach((key) => {
          let valueFormatted = inputOptions[key];
          if (typeof valueFormatted === "object") {
            valueFormatted = formatInputOptions(valueFormatted);
          }
          result.push([key, valueFormatted]);
        });
      }
      return result;
    };
    const isSelected = (optionValue, inputValue) => {
      return inputValue && inputValue.toString() === optionValue.toString();
    };
    const handleConfirmButtonClick = (instance) => {
      const innerParams = privateProps.innerParams.get(instance);
      instance.disableButtons();
      if (innerParams.input) {
        handleConfirmOrDenyWithInput(instance, "confirm");
      } else {
        confirm(instance, true);
      }
    };
    const handleDenyButtonClick = (instance) => {
      const innerParams = privateProps.innerParams.get(instance);
      instance.disableButtons();
      if (innerParams.returnInputValueOnDeny) {
        handleConfirmOrDenyWithInput(instance, "deny");
      } else {
        deny(instance, false);
      }
    };
    const handleCancelButtonClick = (instance, dismissWith) => {
      instance.disableButtons();
      dismissWith(DismissReason.cancel);
    };
    const handleConfirmOrDenyWithInput = (instance, type) => {
      const innerParams = privateProps.innerParams.get(instance);
      if (!innerParams.input) {
        return error('The "input" parameter is needed to be set when using returnInputValueOn'.concat(capitalizeFirstLetter(type)));
      }
      const inputValue = getInputValue(instance, innerParams);
      if (innerParams.inputValidator) {
        handleInputValidator(instance, inputValue, type);
      } else if (!instance.getInput().checkValidity()) {
        instance.enableButtons();
        instance.showValidationMessage(innerParams.validationMessage);
      } else if (type === "deny") {
        deny(instance, inputValue);
      } else {
        confirm(instance, inputValue);
      }
    };
    const handleInputValidator = (instance, inputValue, type) => {
      const innerParams = privateProps.innerParams.get(instance);
      instance.disableInput();
      const validationPromise = Promise.resolve().then(() => asPromise(innerParams.inputValidator(inputValue, innerParams.validationMessage)));
      validationPromise.then((validationMessage) => {
        instance.enableButtons();
        instance.enableInput();
        if (validationMessage) {
          instance.showValidationMessage(validationMessage);
        } else if (type === "deny") {
          deny(instance, inputValue);
        } else {
          confirm(instance, inputValue);
        }
      });
    };
    const deny = (instance, value) => {
      const innerParams = privateProps.innerParams.get(instance || void 0);
      if (innerParams.showLoaderOnDeny) {
        showLoading(getDenyButton());
      }
      if (innerParams.preDeny) {
        privateProps.awaitingPromise.set(instance || void 0, true);
        const preDenyPromise = Promise.resolve().then(() => asPromise(innerParams.preDeny(value, innerParams.validationMessage)));
        preDenyPromise.then((preDenyValue) => {
          if (preDenyValue === false) {
            instance.hideLoading();
          } else {
            instance.closePopup({
              isDenied: true,
              value: typeof preDenyValue === "undefined" ? value : preDenyValue
            });
          }
        }).catch((error$$1) => rejectWith(instance || void 0, error$$1));
      } else {
        instance.closePopup({
          isDenied: true,
          value
        });
      }
    };
    const succeedWith = (instance, value) => {
      instance.closePopup({
        isConfirmed: true,
        value
      });
    };
    const rejectWith = (instance, error$$1) => {
      instance.rejectPromise(error$$1);
    };
    const confirm = (instance, value) => {
      const innerParams = privateProps.innerParams.get(instance || void 0);
      if (innerParams.showLoaderOnConfirm) {
        showLoading();
      }
      if (innerParams.preConfirm) {
        instance.resetValidationMessage();
        privateProps.awaitingPromise.set(instance || void 0, true);
        const preConfirmPromise = Promise.resolve().then(() => asPromise(innerParams.preConfirm(value, innerParams.validationMessage)));
        preConfirmPromise.then((preConfirmValue) => {
          if (isVisible(getValidationMessage()) || preConfirmValue === false) {
            instance.hideLoading();
          } else {
            succeedWith(instance, typeof preConfirmValue === "undefined" ? value : preConfirmValue);
          }
        }).catch((error$$1) => rejectWith(instance || void 0, error$$1));
      } else {
        succeedWith(instance, value);
      }
    };
    const handlePopupClick = (instance, domCache, dismissWith) => {
      const innerParams = privateProps.innerParams.get(instance);
      if (innerParams.toast) {
        handleToastClick(instance, domCache, dismissWith);
      } else {
        handleModalMousedown(domCache);
        handleContainerMousedown(domCache);
        handleModalClick(instance, domCache, dismissWith);
      }
    };
    const handleToastClick = (instance, domCache, dismissWith) => {
      domCache.popup.onclick = () => {
        const innerParams = privateProps.innerParams.get(instance);
        if (innerParams && (isAnyButtonShown(innerParams) || innerParams.timer || innerParams.input)) {
          return;
        }
        dismissWith(DismissReason.close);
      };
    };
    const isAnyButtonShown = (innerParams) => {
      return innerParams.showConfirmButton || innerParams.showDenyButton || innerParams.showCancelButton || innerParams.showCloseButton;
    };
    let ignoreOutsideClick = false;
    const handleModalMousedown = (domCache) => {
      domCache.popup.onmousedown = () => {
        domCache.container.onmouseup = function(e) {
          domCache.container.onmouseup = void 0;
          if (e.target === domCache.container) {
            ignoreOutsideClick = true;
          }
        };
      };
    };
    const handleContainerMousedown = (domCache) => {
      domCache.container.onmousedown = () => {
        domCache.popup.onmouseup = function(e) {
          domCache.popup.onmouseup = void 0;
          if (e.target === domCache.popup || domCache.popup.contains(e.target)) {
            ignoreOutsideClick = true;
          }
        };
      };
    };
    const handleModalClick = (instance, domCache, dismissWith) => {
      domCache.container.onclick = (e) => {
        const innerParams = privateProps.innerParams.get(instance);
        if (ignoreOutsideClick) {
          ignoreOutsideClick = false;
          return;
        }
        if (e.target === domCache.container && callIfFunction(innerParams.allowOutsideClick)) {
          dismissWith(DismissReason.backdrop);
        }
      };
    };
    const isVisible$1 = () => {
      return isVisible(getPopup());
    };
    const clickConfirm = () => getConfirmButton() && getConfirmButton().click();
    const clickDeny = () => getDenyButton() && getDenyButton().click();
    const clickCancel = () => getCancelButton() && getCancelButton().click();
    const addKeydownHandler = (instance, globalState2, innerParams, dismissWith) => {
      if (globalState2.keydownTarget && globalState2.keydownHandlerAdded) {
        globalState2.keydownTarget.removeEventListener("keydown", globalState2.keydownHandler, {
          capture: globalState2.keydownListenerCapture
        });
        globalState2.keydownHandlerAdded = false;
      }
      if (!innerParams.toast) {
        globalState2.keydownHandler = (e) => keydownHandler(instance, e, dismissWith);
        globalState2.keydownTarget = innerParams.keydownListenerCapture ? window : getPopup();
        globalState2.keydownListenerCapture = innerParams.keydownListenerCapture;
        globalState2.keydownTarget.addEventListener("keydown", globalState2.keydownHandler, {
          capture: globalState2.keydownListenerCapture
        });
        globalState2.keydownHandlerAdded = true;
      }
    };
    const setFocus = (innerParams, index, increment) => {
      const focusableElements = getFocusableElements();
      if (focusableElements.length) {
        index = index + increment;
        if (index === focusableElements.length) {
          index = 0;
        } else if (index === -1) {
          index = focusableElements.length - 1;
        }
        return focusableElements[index].focus();
      }
      getPopup().focus();
    };
    const arrowKeysNextButton = ["ArrowRight", "ArrowDown"];
    const arrowKeysPreviousButton = ["ArrowLeft", "ArrowUp"];
    const keydownHandler = (instance, e, dismissWith) => {
      const innerParams = privateProps.innerParams.get(instance);
      if (!innerParams) {
        return;
      }
      if (innerParams.stopKeydownPropagation) {
        e.stopPropagation();
      }
      if (e.key === "Enter") {
        handleEnter(instance, e, innerParams);
      } else if (e.key === "Tab") {
        handleTab(e, innerParams);
      } else if ([...arrowKeysNextButton, ...arrowKeysPreviousButton].includes(e.key)) {
        handleArrows(e.key);
      } else if (e.key === "Escape") {
        handleEsc(e, innerParams, dismissWith);
      }
    };
    const handleEnter = (instance, e, innerParams) => {
      if (!callIfFunction(innerParams.allowEnterKey) || e.isComposing) {
        return;
      }
      if (e.target && instance.getInput() && e.target.outerHTML === instance.getInput().outerHTML) {
        if (["textarea", "file"].includes(innerParams.input)) {
          return;
        }
        clickConfirm();
        e.preventDefault();
      }
    };
    const handleTab = (e, innerParams) => {
      const targetElement = e.target;
      const focusableElements = getFocusableElements();
      let btnIndex = -1;
      for (let i = 0; i < focusableElements.length; i++) {
        if (targetElement === focusableElements[i]) {
          btnIndex = i;
          break;
        }
      }
      if (!e.shiftKey) {
        setFocus(innerParams, btnIndex, 1);
      } else {
        setFocus(innerParams, btnIndex, -1);
      }
      e.stopPropagation();
      e.preventDefault();
    };
    const handleArrows = (key) => {
      const confirmButton = getConfirmButton();
      const denyButton = getDenyButton();
      const cancelButton = getCancelButton();
      if (![confirmButton, denyButton, cancelButton].includes(document.activeElement)) {
        return;
      }
      const sibling = arrowKeysNextButton.includes(key) ? "nextElementSibling" : "previousElementSibling";
      const buttonToFocus = document.activeElement[sibling];
      if (buttonToFocus instanceof HTMLElement) {
        buttonToFocus.focus();
      }
    };
    const handleEsc = (e, innerParams, dismissWith) => {
      if (callIfFunction(innerParams.allowEscapeKey)) {
        e.preventDefault();
        dismissWith(DismissReason.esc);
      }
    };
    const isJqueryElement = (elem) => typeof elem === "object" && elem.jquery;
    const isElement = (elem) => elem instanceof Element || isJqueryElement(elem);
    const argsToParams = (args) => {
      const params = {};
      if (typeof args[0] === "object" && !isElement(args[0])) {
        Object.assign(params, args[0]);
      } else {
        ["title", "html", "icon"].forEach((name, index) => {
          const arg = args[index];
          if (typeof arg === "string" || isElement(arg)) {
            params[name] = arg;
          } else if (arg !== void 0) {
            error("Unexpected type of ".concat(name, '! Expected "string" or "Element", got ').concat(typeof arg));
          }
        });
      }
      return params;
    };
    function fire() {
      const Swal3 = this;
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      return new Swal3(...args);
    }
    function mixin(mixinParams) {
      class MixinSwal extends this {
        _main(params, priorityMixinParams) {
          return super._main(params, Object.assign({}, mixinParams, priorityMixinParams));
        }
      }
      return MixinSwal;
    }
    const getTimerLeft = () => {
      return globalState.timeout && globalState.timeout.getTimerLeft();
    };
    const stopTimer = () => {
      if (globalState.timeout) {
        stopTimerProgressBar();
        return globalState.timeout.stop();
      }
    };
    const resumeTimer = () => {
      if (globalState.timeout) {
        const remaining = globalState.timeout.start();
        animateTimerProgressBar(remaining);
        return remaining;
      }
    };
    const toggleTimer = () => {
      const timer = globalState.timeout;
      return timer && (timer.running ? stopTimer() : resumeTimer());
    };
    const increaseTimer = (n) => {
      if (globalState.timeout) {
        const remaining = globalState.timeout.increase(n);
        animateTimerProgressBar(remaining, true);
        return remaining;
      }
    };
    const isTimerRunning = () => {
      return globalState.timeout && globalState.timeout.isRunning();
    };
    let bodyClickListenerAdded = false;
    const clickHandlers = {};
    function bindClickHandler() {
      let attr = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : "data-swal-template";
      clickHandlers[attr] = this;
      if (!bodyClickListenerAdded) {
        document.body.addEventListener("click", bodyClickListener);
        bodyClickListenerAdded = true;
      }
    }
    const bodyClickListener = (event) => {
      for (let el = event.target; el && el !== document; el = el.parentNode) {
        for (const attr in clickHandlers) {
          const template = el.getAttribute(attr);
          if (template) {
            clickHandlers[attr].fire({
              template
            });
            return;
          }
        }
      }
    };
    var staticMethods = Object.freeze({
      isValidParameter,
      isUpdatableParameter,
      isDeprecatedParameter,
      argsToParams,
      isVisible: isVisible$1,
      clickConfirm,
      clickDeny,
      clickCancel,
      getContainer,
      getPopup,
      getTitle,
      getHtmlContainer,
      getImage,
      getIcon,
      getInputLabel,
      getCloseButton,
      getActions,
      getConfirmButton,
      getDenyButton,
      getCancelButton,
      getLoader,
      getFooter,
      getTimerProgressBar,
      getFocusableElements,
      getValidationMessage,
      isLoading,
      fire,
      mixin,
      showLoading,
      enableLoading: showLoading,
      getTimerLeft,
      stopTimer,
      resumeTimer,
      toggleTimer,
      increaseTimer,
      isTimerRunning,
      bindClickHandler
    });
    function hideLoading() {
      const innerParams = privateProps.innerParams.get(this);
      if (!innerParams) {
        return;
      }
      const domCache = privateProps.domCache.get(this);
      hide(domCache.loader);
      if (isToast()) {
        if (innerParams.icon) {
          show(getIcon());
        }
      } else {
        showRelatedButton(domCache);
      }
      removeClass([domCache.popup, domCache.actions], swalClasses.loading);
      domCache.popup.removeAttribute("aria-busy");
      domCache.popup.removeAttribute("data-loading");
      domCache.confirmButton.disabled = false;
      domCache.denyButton.disabled = false;
      domCache.cancelButton.disabled = false;
    }
    const showRelatedButton = (domCache) => {
      const buttonToReplace = domCache.popup.getElementsByClassName(domCache.loader.getAttribute("data-button-to-replace"));
      if (buttonToReplace.length) {
        show(buttonToReplace[0], "inline-block");
      } else if (allButtonsAreHidden()) {
        hide(domCache.actions);
      }
    };
    function getInput$1(instance) {
      const innerParams = privateProps.innerParams.get(instance || this);
      const domCache = privateProps.domCache.get(instance || this);
      if (!domCache) {
        return null;
      }
      return getInput(domCache.popup, innerParams.input);
    }
    var privateMethods = {
      swalPromiseResolve: /* @__PURE__ */ new WeakMap(),
      swalPromiseReject: /* @__PURE__ */ new WeakMap()
    };
    function removePopupAndResetState(instance, container, returnFocus, didClose) {
      if (isToast()) {
        triggerDidCloseAndDispose(instance, didClose);
      } else {
        restoreActiveElement(returnFocus).then(() => triggerDidCloseAndDispose(instance, didClose));
        globalState.keydownTarget.removeEventListener("keydown", globalState.keydownHandler, {
          capture: globalState.keydownListenerCapture
        });
        globalState.keydownHandlerAdded = false;
      }
      const isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
      if (isSafari) {
        container.setAttribute("style", "display:none !important");
        container.removeAttribute("class");
        container.innerHTML = "";
      } else {
        container.remove();
      }
      if (isModal()) {
        undoScrollbar();
        undoIOSfix();
        unsetAriaHidden();
      }
      removeBodyClasses();
    }
    function removeBodyClasses() {
      removeClass([document.documentElement, document.body], [swalClasses.shown, swalClasses["height-auto"], swalClasses["no-backdrop"], swalClasses["toast-shown"]]);
    }
    function close(resolveValue) {
      resolveValue = prepareResolveValue(resolveValue);
      const swalPromiseResolve = privateMethods.swalPromiseResolve.get(this);
      const didClose = triggerClosePopup(this);
      if (this.isAwaitingPromise()) {
        if (!resolveValue.isDismissed) {
          handleAwaitingPromise(this);
          swalPromiseResolve(resolveValue);
        }
      } else if (didClose) {
        swalPromiseResolve(resolveValue);
      }
    }
    function isAwaitingPromise() {
      return !!privateProps.awaitingPromise.get(this);
    }
    const triggerClosePopup = (instance) => {
      const popup = getPopup();
      if (!popup) {
        return false;
      }
      const innerParams = privateProps.innerParams.get(instance);
      if (!innerParams || hasClass(popup, innerParams.hideClass.popup)) {
        return false;
      }
      removeClass(popup, innerParams.showClass.popup);
      addClass(popup, innerParams.hideClass.popup);
      const backdrop = getContainer();
      removeClass(backdrop, innerParams.showClass.backdrop);
      addClass(backdrop, innerParams.hideClass.backdrop);
      handlePopupAnimation(instance, popup, innerParams);
      return true;
    };
    function rejectPromise(error2) {
      const rejectPromise2 = privateMethods.swalPromiseReject.get(this);
      handleAwaitingPromise(this);
      if (rejectPromise2) {
        rejectPromise2(error2);
      }
    }
    const handleAwaitingPromise = (instance) => {
      if (instance.isAwaitingPromise()) {
        privateProps.awaitingPromise.delete(instance);
        if (!privateProps.innerParams.get(instance)) {
          instance._destroy();
        }
      }
    };
    const prepareResolveValue = (resolveValue) => {
      if (typeof resolveValue === "undefined") {
        return {
          isConfirmed: false,
          isDenied: false,
          isDismissed: true
        };
      }
      return Object.assign({
        isConfirmed: false,
        isDenied: false,
        isDismissed: false
      }, resolveValue);
    };
    const handlePopupAnimation = (instance, popup, innerParams) => {
      const container = getContainer();
      const animationIsSupported = animationEndEvent && hasCssAnimation(popup);
      if (typeof innerParams.willClose === "function") {
        innerParams.willClose(popup);
      }
      if (animationIsSupported) {
        animatePopup(instance, popup, container, innerParams.returnFocus, innerParams.didClose);
      } else {
        removePopupAndResetState(instance, container, innerParams.returnFocus, innerParams.didClose);
      }
    };
    const animatePopup = (instance, popup, container, returnFocus, didClose) => {
      globalState.swalCloseEventFinishedCallback = removePopupAndResetState.bind(null, instance, container, returnFocus, didClose);
      popup.addEventListener(animationEndEvent, function(e) {
        if (e.target === popup) {
          globalState.swalCloseEventFinishedCallback();
          delete globalState.swalCloseEventFinishedCallback;
        }
      });
    };
    const triggerDidCloseAndDispose = (instance, didClose) => {
      setTimeout(() => {
        if (typeof didClose === "function") {
          didClose.bind(instance.params)();
        }
        instance._destroy();
      });
    };
    function setButtonsDisabled(instance, buttons, disabled) {
      const domCache = privateProps.domCache.get(instance);
      buttons.forEach((button) => {
        domCache[button].disabled = disabled;
      });
    }
    function setInputDisabled(input, disabled) {
      if (!input) {
        return false;
      }
      if (input.type === "radio") {
        const radiosContainer = input.parentNode.parentNode;
        const radios = radiosContainer.querySelectorAll("input");
        for (let i = 0; i < radios.length; i++) {
          radios[i].disabled = disabled;
        }
      } else {
        input.disabled = disabled;
      }
    }
    function enableButtons() {
      setButtonsDisabled(this, ["confirmButton", "denyButton", "cancelButton"], false);
    }
    function disableButtons() {
      setButtonsDisabled(this, ["confirmButton", "denyButton", "cancelButton"], true);
    }
    function enableInput() {
      return setInputDisabled(this.getInput(), false);
    }
    function disableInput() {
      return setInputDisabled(this.getInput(), true);
    }
    function showValidationMessage(error2) {
      const domCache = privateProps.domCache.get(this);
      const params = privateProps.innerParams.get(this);
      setInnerHtml(domCache.validationMessage, error2);
      domCache.validationMessage.className = swalClasses["validation-message"];
      if (params.customClass && params.customClass.validationMessage) {
        addClass(domCache.validationMessage, params.customClass.validationMessage);
      }
      show(domCache.validationMessage);
      const input = this.getInput();
      if (input) {
        input.setAttribute("aria-invalid", true);
        input.setAttribute("aria-describedby", swalClasses["validation-message"]);
        focusInput(input);
        addClass(input, swalClasses.inputerror);
      }
    }
    function resetValidationMessage$1() {
      const domCache = privateProps.domCache.get(this);
      if (domCache.validationMessage) {
        hide(domCache.validationMessage);
      }
      const input = this.getInput();
      if (input) {
        input.removeAttribute("aria-invalid");
        input.removeAttribute("aria-describedby");
        removeClass(input, swalClasses.inputerror);
      }
    }
    function getProgressSteps$1() {
      const domCache = privateProps.domCache.get(this);
      return domCache.progressSteps;
    }
    function update(params) {
      const popup = getPopup();
      const innerParams = privateProps.innerParams.get(this);
      if (!popup || hasClass(popup, innerParams.hideClass.popup)) {
        return warn("You're trying to update the closed or closing popup, that won't work. Use the update() method in preConfirm parameter or show a new popup.");
      }
      const validUpdatableParams = filterValidParams(params);
      const updatedParams = Object.assign({}, innerParams, validUpdatableParams);
      render(this, updatedParams);
      privateProps.innerParams.set(this, updatedParams);
      Object.defineProperties(this, {
        params: {
          value: Object.assign({}, this.params, params),
          writable: false,
          enumerable: true
        }
      });
    }
    const filterValidParams = (params) => {
      const validUpdatableParams = {};
      Object.keys(params).forEach((param) => {
        if (isUpdatableParameter(param)) {
          validUpdatableParams[param] = params[param];
        } else {
          warn('Invalid parameter to update: "'.concat(param, '". Updatable params are listed here: https://github.com/sweetalert2/sweetalert2/blob/master/src/utils/params.js\n\nIf you think this parameter should be updatable, request it here: https://github.com/sweetalert2/sweetalert2/issues/new?template=02_feature_request.md'));
        }
      });
      return validUpdatableParams;
    };
    function _destroy() {
      const domCache = privateProps.domCache.get(this);
      const innerParams = privateProps.innerParams.get(this);
      if (!innerParams) {
        disposeWeakMaps(this);
        return;
      }
      if (domCache.popup && globalState.swalCloseEventFinishedCallback) {
        globalState.swalCloseEventFinishedCallback();
        delete globalState.swalCloseEventFinishedCallback;
      }
      if (globalState.deferDisposalTimer) {
        clearTimeout(globalState.deferDisposalTimer);
        delete globalState.deferDisposalTimer;
      }
      if (typeof innerParams.didDestroy === "function") {
        innerParams.didDestroy();
      }
      disposeSwal(this);
    }
    const disposeSwal = (instance) => {
      disposeWeakMaps(instance);
      delete instance.params;
      delete globalState.keydownHandler;
      delete globalState.keydownTarget;
      delete globalState.currentInstance;
    };
    const disposeWeakMaps = (instance) => {
      if (instance.isAwaitingPromise()) {
        unsetWeakMaps(privateProps, instance);
        privateProps.awaitingPromise.set(instance, true);
      } else {
        unsetWeakMaps(privateMethods, instance);
        unsetWeakMaps(privateProps, instance);
      }
    };
    const unsetWeakMaps = (obj, instance) => {
      for (const i in obj) {
        obj[i].delete(instance);
      }
    };
    var instanceMethods = Object.freeze({
      hideLoading,
      disableLoading: hideLoading,
      getInput: getInput$1,
      close,
      isAwaitingPromise,
      rejectPromise,
      closePopup: close,
      closeModal: close,
      closeToast: close,
      enableButtons,
      disableButtons,
      enableInput,
      disableInput,
      showValidationMessage,
      resetValidationMessage: resetValidationMessage$1,
      getProgressSteps: getProgressSteps$1,
      update,
      _destroy
    });
    let currentInstance;
    class SweetAlert {
      constructor() {
        if (typeof window === "undefined") {
          return;
        }
        currentInstance = this;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        const outerParams = Object.freeze(this.constructor.argsToParams(args));
        Object.defineProperties(this, {
          params: {
            value: outerParams,
            writable: false,
            enumerable: true,
            configurable: true
          }
        });
        const promise = this._main(this.params);
        privateProps.promise.set(this, promise);
      }
      _main(userParams) {
        let mixinParams = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
        showWarningsForParams(Object.assign({}, mixinParams, userParams));
        if (globalState.currentInstance) {
          globalState.currentInstance._destroy();
          if (isModal()) {
            unsetAriaHidden();
          }
        }
        globalState.currentInstance = this;
        const innerParams = prepareParams(userParams, mixinParams);
        setParameters(innerParams);
        Object.freeze(innerParams);
        if (globalState.timeout) {
          globalState.timeout.stop();
          delete globalState.timeout;
        }
        clearTimeout(globalState.restoreFocusTimeout);
        const domCache = populateDomCache(this);
        render(this, innerParams);
        privateProps.innerParams.set(this, innerParams);
        return swalPromise(this, domCache, innerParams);
      }
      then(onFulfilled) {
        const promise = privateProps.promise.get(this);
        return promise.then(onFulfilled);
      }
      finally(onFinally) {
        const promise = privateProps.promise.get(this);
        return promise.finally(onFinally);
      }
    }
    const swalPromise = (instance, domCache, innerParams) => {
      return new Promise((resolve, reject) => {
        const dismissWith = (dismiss) => {
          instance.closePopup({
            isDismissed: true,
            dismiss
          });
        };
        privateMethods.swalPromiseResolve.set(instance, resolve);
        privateMethods.swalPromiseReject.set(instance, reject);
        domCache.confirmButton.onclick = () => handleConfirmButtonClick(instance);
        domCache.denyButton.onclick = () => handleDenyButtonClick(instance);
        domCache.cancelButton.onclick = () => handleCancelButtonClick(instance, dismissWith);
        domCache.closeButton.onclick = () => dismissWith(DismissReason.close);
        handlePopupClick(instance, domCache, dismissWith);
        addKeydownHandler(instance, globalState, innerParams, dismissWith);
        handleInputOptionsAndValue(instance, innerParams);
        openPopup(innerParams);
        setupTimer(globalState, innerParams, dismissWith);
        initFocus(domCache, innerParams);
        setTimeout(() => {
          domCache.container.scrollTop = 0;
        });
      });
    };
    const prepareParams = (userParams, mixinParams) => {
      const templateParams = getTemplateParams(userParams);
      const params = Object.assign({}, defaultParams, mixinParams, templateParams, userParams);
      params.showClass = Object.assign({}, defaultParams.showClass, params.showClass);
      params.hideClass = Object.assign({}, defaultParams.hideClass, params.hideClass);
      return params;
    };
    const populateDomCache = (instance) => {
      const domCache = {
        popup: getPopup(),
        container: getContainer(),
        actions: getActions(),
        confirmButton: getConfirmButton(),
        denyButton: getDenyButton(),
        cancelButton: getCancelButton(),
        loader: getLoader(),
        closeButton: getCloseButton(),
        validationMessage: getValidationMessage(),
        progressSteps: getProgressSteps()
      };
      privateProps.domCache.set(instance, domCache);
      return domCache;
    };
    const setupTimer = (globalState$$1, innerParams, dismissWith) => {
      const timerProgressBar = getTimerProgressBar();
      hide(timerProgressBar);
      if (innerParams.timer) {
        globalState$$1.timeout = new Timer(() => {
          dismissWith("timer");
          delete globalState$$1.timeout;
        }, innerParams.timer);
        if (innerParams.timerProgressBar) {
          show(timerProgressBar);
          applyCustomClass(timerProgressBar, innerParams, "timerProgressBar");
          setTimeout(() => {
            if (globalState$$1.timeout && globalState$$1.timeout.running) {
              animateTimerProgressBar(innerParams.timer);
            }
          });
        }
      }
    };
    const initFocus = (domCache, innerParams) => {
      if (innerParams.toast) {
        return;
      }
      if (!callIfFunction(innerParams.allowEnterKey)) {
        return blurActiveElement();
      }
      if (!focusButton(domCache, innerParams)) {
        setFocus(innerParams, -1, 1);
      }
    };
    const focusButton = (domCache, innerParams) => {
      if (innerParams.focusDeny && isVisible(domCache.denyButton)) {
        domCache.denyButton.focus();
        return true;
      }
      if (innerParams.focusCancel && isVisible(domCache.cancelButton)) {
        domCache.cancelButton.focus();
        return true;
      }
      if (innerParams.focusConfirm && isVisible(domCache.confirmButton)) {
        domCache.confirmButton.focus();
        return true;
      }
      return false;
    };
    const blurActiveElement = () => {
      if (document.activeElement instanceof HTMLElement && typeof document.activeElement.blur === "function") {
        document.activeElement.blur();
      }
    };
    Object.assign(SweetAlert.prototype, instanceMethods);
    Object.assign(SweetAlert, staticMethods);
    Object.keys(instanceMethods).forEach((key) => {
      SweetAlert[key] = function() {
        if (currentInstance) {
          return currentInstance[key](...arguments);
        }
      };
    });
    SweetAlert.DismissReason = DismissReason;
    SweetAlert.version = "11.4.0";
    const Swal2 = SweetAlert;
    Swal2.default = Swal2;
    return Swal2;
  });
  if (typeof commonjsGlobal !== "undefined" && commonjsGlobal.Sweetalert2) {
    commonjsGlobal.swal = commonjsGlobal.sweetAlert = commonjsGlobal.Swal = commonjsGlobal.SweetAlert = commonjsGlobal.Sweetalert2;
  }
})(sweetalert2);
var Swal = sweetalert2.exports;
var VueSweetalert2 = class {
  static install(vue, options = {}) {
    var _a;
    const swalLocalInstance = Swal.mixin(options);
    const swalFunction = function(...args) {
      return swalLocalInstance.fire.call(swalLocalInstance, ...args);
    };
    Object.assign(swalFunction, Swal);
    Object.keys(Swal).filter((key) => typeof Swal[key] === "function").forEach((methodName) => {
      swalFunction[methodName] = swalLocalInstance[methodName].bind(swalLocalInstance);
    });
    if (((_a = vue.config) == null ? void 0 : _a.globalProperties) && !vue.config.globalProperties.$swal) {
      vue.config.globalProperties.$swal = swalFunction;
      vue.provide("$swal", swalFunction);
    } else if (!Object.prototype.hasOwnProperty.call(vue, "$swal")) {
      vue.prototype.$swal = swalFunction;
      vue["swal"] = swalFunction;
    }
  }
};
export {
  VueSweetalert2 as default
};
/*! Bundled license information:

vue-sweetalert2/dist/vue-sweetalert.es.js:
  (*!
  * sweetalert2 v11.4.0
  * Released under the MIT License.
  *)
*/
//# sourceMappingURL=vue-sweetalert2.js.map
