import {
  script
} from "./chunk-6FMTRCV7.js";
import "./chunk-ERO7GNQR.js";
import {
  BaseStyle
} from "./chunk-MA4TN6QH.js";
import "./chunk-NX5QSUXY.js";
import "./chunk-AL7RQG6J.js";
import "./chunk-FLSNA7AK.js";
import {
  Fragment,
  createBaseVNode,
  createCommentVNode,
  createElementBlock,
  createVNode,
  mergeProps,
  normalizeClass,
  openBlock,
  renderList,
  renderSlot,
  resolveComponent,
  toDisplayString
} from "./chunk-DIASZOHW.js";
import "./chunk-WXXH56N5.js";

// node_modules/primevue/metergroup/style/index.mjs
var theme = function theme2(_ref) {
  var dt = _ref.dt;
  return "\n.p-metergroup {\n    display: flex;\n    gap: ".concat(dt("metergroup.gap"), ";\n}\n\n.p-metergroup-meters {\n    display: flex;\n    background: ").concat(dt("metergroup.meters.background"), ";\n    border-radius: ").concat(dt("metergroup.border.radius"), ";\n}\n\n.p-metergroup-label-list {\n    display: flex;\n    flex-wrap: wrap;\n    margin: 0;\n    padding: 0;\n    list-style-type: none;\n}\n\n.p-metergroup-label {\n    display: inline-flex;\n    align-items: center;\n    gap: ").concat(dt("metergroup.label.gap"), ";\n}\n\n.p-metergroup-label-marker {\n    display: inline-flex;\n    width: ").concat(dt("metergroup.label.marker.size"), ";\n    height: ").concat(dt("metergroup.label.marker.size"), ";\n    border-radius: 100%;\n}\n\n.p-metergroup-label-icon {\n    font-size: ").concat(dt("metergroup.label.icon.size"), ";\n    width: ").concat(dt("metergroup.label.icon.size"), ";\n    height: ").concat(dt("metergroup.label.icon.size"), ";\n}\n\n.p-metergroup-horizontal {\n    flex-direction: column;\n}\n\n.p-metergroup-label-list-horizontal {\n    gap: ").concat(dt("metergroup.label.list.horizontal.gap"), ";\n}\n\n.p-metergroup-horizontal .p-metergroup-meters {\n    height: ").concat(dt("metergroup.meters.size"), ";\n}\n\n.p-metergroup-horizontal .p-metergroup-meter:first-of-type {\n    border-top-left-radius: ").concat(dt("metergroup.border.radius"), ";\n    border-bottom-left-radius: ").concat(dt("metergroup.border.radius"), ";\n}\n\n.p-metergroup-horizontal .p-metergroup-meter:last-of-type {\n    border-top-right-radius: ").concat(dt("metergroup.border.radius"), ";\n    border-bottom-right-radius: ").concat(dt("metergroup.border.radius"), ";\n}\n\n.p-metergroup-vertical {\n    flex-direction: row;\n}\n\n.p-metergroup-label-list-vertical {\n    flex-direction: column;\n    gap: ").concat(dt("metergroup.label.list.vertical.gap"), ";\n}\n\n.p-metergroup-vertical .p-metergroup-meters {\n    flex-direction: column;\n    width: ").concat(dt("metergroup.meters.size"), ";\n    height: 100%;\n}\n\n.p-metergroup-vertical .p-metergroup-label-list {\n    align-items: start;\n}\n\n.p-metergroup-vertical .p-metergroup-meter:first-of-type {\n    border-top-left-radius: ").concat(dt("metergroup.border.radius"), ";\n    border-top-right-radius: ").concat(dt("metergroup.border.radius"), ";\n}\n.p-metergroup-vertical .p-metergroup-meter:last-of-type {\n    border-bottom-left-radius: ").concat(dt("metergroup.border.radius"), ";\n    border-bottom-right-radius: ").concat(dt("metergroup.border.radius"), ";\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var props = _ref2.props;
    return ["p-metergroup p-component", {
      "p-metergroup-horizontal": props.orientation === "horizontal",
      "p-metergroup-vertical": props.orientation === "vertical"
    }];
  },
  meters: "p-metergroup-meters",
  meter: "p-metergroup-meter",
  labelList: function labelList(_ref3) {
    var props = _ref3.props;
    return ["p-metergroup-label-list", {
      "p-metergroup-label-list-vertical": props.labelOrientation === "vertical",
      "p-metergroup-label-list-horizontal": props.labelOrientation === "horizontal"
    }];
  },
  label: "p-metergroup-label",
  labelIcon: "p-metergroup-label-icon",
  labelMarker: "p-metergroup-label-marker",
  labelText: "p-metergroup-label-text"
};
var MeterGroupStyle = BaseStyle.extend({
  name: "metergroup",
  theme,
  classes
});

// node_modules/primevue/metergroup/index.mjs
var script$2 = {
  name: "MeterGroup",
  "extends": script,
  props: {
    value: {
      type: Array,
      "default": null
    },
    min: {
      type: Number,
      "default": 0
    },
    max: {
      type: Number,
      "default": 100
    },
    orientation: {
      type: String,
      "default": "horizontal"
    },
    labelPosition: {
      type: String,
      "default": "end"
    },
    labelOrientation: {
      type: String,
      "default": "horizontal"
    }
  },
  style: MeterGroupStyle,
  provide: function provide() {
    return {
      $pcMeterGroup: this,
      $parentInstance: this
    };
  }
};
var script$1 = {
  name: "MeterGroupLabel",
  hostName: "MeterGroup",
  "extends": script,
  inheritAttrs: false,
  props: {
    value: {
      type: Array,
      "default": null
    },
    labelPosition: {
      type: String,
      "default": "end"
    },
    labelOrientation: {
      type: String,
      "default": "horizontal"
    }
  }
};
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("ol", mergeProps({
    "class": _ctx.cx("labelList")
  }, _ctx.ptm("labelList")), [(openBlock(true), createElementBlock(Fragment, null, renderList($props.value, function(val, index) {
    return openBlock(), createElementBlock("li", mergeProps({
      key: index + "_label",
      "class": _ctx.cx("label"),
      ref_for: true
    }, _ctx.ptm("label")), [renderSlot(_ctx.$slots, "icon", {
      value: val,
      "class": normalizeClass(_ctx.cx("labelIcon"))
    }, function() {
      return [val.icon ? (openBlock(), createElementBlock("i", mergeProps({
        key: 0,
        "class": [val.icon, _ctx.cx("labelIcon")],
        style: {
          color: val.color
        },
        ref_for: true
      }, _ctx.ptm("labelIcon")), null, 16)) : (openBlock(), createElementBlock("span", mergeProps({
        key: 1,
        "class": _ctx.cx("labelMarker"),
        style: {
          backgroundColor: val.color
        },
        ref_for: true
      }, _ctx.ptm("labelMarker")), null, 16))];
    }), createBaseVNode("span", mergeProps({
      "class": _ctx.cx("labelText"),
      ref_for: true
    }, _ctx.ptm("labelText")), toDisplayString(val.label) + " (" + toDisplayString(_ctx.$parentInstance.percentValue(val.value)) + ")", 17)], 16);
  }), 128))], 16);
}
script$1.render = render$1;
var script2 = {
  name: "MeterGroup",
  "extends": script$2,
  inheritAttrs: false,
  methods: {
    getPTOptions: function getPTOptions(key, value, index) {
      return this.ptm(key, {
        context: {
          value,
          index
        }
      });
    },
    percent: function percent() {
      var meter = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : 0;
      var percentOfItem = (meter - this.min) / (this.max - this.min) * 100;
      return Math.round(Math.max(0, Math.min(100, percentOfItem)));
    },
    percentValue: function percentValue(meter) {
      return this.percent(meter) + "%";
    },
    meterCalculatedStyles: function meterCalculatedStyles(val) {
      return {
        backgroundColor: val.color,
        width: this.orientation === "horizontal" && this.percentValue(val.value),
        height: this.orientation === "vertical" && this.percentValue(val.value)
      };
    }
  },
  computed: {
    totalPercent: function totalPercent() {
      return this.percent(this.value.reduce(function(total, val) {
        return total + val.value;
      }, 0));
    },
    percentages: function percentages() {
      var sum = 0;
      var sumsArray = [];
      this.value.forEach(function(item) {
        sum += item.value;
        sumsArray.push(sum);
      });
      return sumsArray;
    }
  },
  components: {
    MeterGroupLabel: script$1
  }
};
var _hoisted_1 = ["aria-valuemin", "aria-valuemax", "aria-valuenow"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_MeterGroupLabel = resolveComponent("MeterGroupLabel");
  return openBlock(), createElementBlock("div", mergeProps({
    "class": _ctx.cx("root"),
    role: "meter",
    "aria-valuemin": _ctx.min,
    "aria-valuemax": _ctx.max,
    "aria-valuenow": $options.totalPercent
  }, _ctx.ptmi("root")), [_ctx.labelPosition === "start" ? renderSlot(_ctx.$slots, "label", {
    key: 0,
    value: _ctx.value,
    totalPercent: $options.totalPercent,
    percentages: $options.percentages
  }, function() {
    return [createVNode(_component_MeterGroupLabel, {
      value: _ctx.value,
      labelPosition: _ctx.labelPosition,
      labelOrientation: _ctx.labelOrientation,
      unstyled: _ctx.unstyled,
      pt: _ctx.pt
    }, null, 8, ["value", "labelPosition", "labelOrientation", "unstyled", "pt"])];
  }) : createCommentVNode("", true), renderSlot(_ctx.$slots, "start", {
    value: _ctx.value,
    totalPercent: $options.totalPercent,
    percentages: $options.percentages
  }), createBaseVNode("div", mergeProps({
    "class": _ctx.cx("meters")
  }, _ctx.ptm("meters")), [(openBlock(true), createElementBlock(Fragment, null, renderList(_ctx.value, function(val, index) {
    return renderSlot(_ctx.$slots, "meter", {
      key: index,
      value: val,
      index,
      "class": normalizeClass(_ctx.cx("meter")),
      orientation: _ctx.orientation,
      size: $options.percentValue(val.value),
      totalPercent: $options.totalPercent
    }, function() {
      return [$options.percent(val.value) ? (openBlock(), createElementBlock("span", mergeProps({
        key: 0,
        "class": _ctx.cx("meter"),
        style: $options.meterCalculatedStyles(val),
        ref_for: true
      }, $options.getPTOptions("meter", val, index)), null, 16)) : createCommentVNode("", true)];
    });
  }), 128))], 16), renderSlot(_ctx.$slots, "end", {
    value: _ctx.value,
    totalPercent: $options.totalPercent,
    percentages: $options.percentages
  }), _ctx.labelPosition === "end" ? renderSlot(_ctx.$slots, "label", {
    key: 1,
    value: _ctx.value,
    totalPercent: $options.totalPercent,
    percentages: $options.percentages
  }, function() {
    return [createVNode(_component_MeterGroupLabel, {
      value: _ctx.value,
      labelPosition: _ctx.labelPosition,
      labelOrientation: _ctx.labelOrientation,
      unstyled: _ctx.unstyled,
      pt: _ctx.pt
    }, null, 8, ["value", "labelPosition", "labelOrientation", "unstyled", "pt"])];
  }) : createCommentVNode("", true)], 16, _hoisted_1);
}
script2.render = render;
export {
  script2 as default
};
//# sourceMappingURL=primevue_metergroup.js.map
