import {
  script
} from "./chunk-6FMTRCV7.js";
import {
  BaseStyle
} from "./chunk-MA4TN6QH.js";
import {
  createBaseVNode,
  createElementBlock,
  mergeProps,
  openBlock
} from "./chunk-DIASZOHW.js";

// node_modules/primevue/toggleswitch/style/index.mjs
var theme = function theme2(_ref) {
  var dt = _ref.dt;
  return "\n.p-toggleswitch {\n    display: inline-block;\n    width: ".concat(dt("toggleswitch.width"), ";\n    height: ").concat(dt("toggleswitch.height"), ";\n}\n\n.p-toggleswitch-input {\n    cursor: pointer;\n    appearance: none;\n    position: absolute;\n    top: 0;\n    left: 0;\n    width: 100%;\n    height: 100%;\n    padding: 0;\n    margin: 0;\n    opacity: 0;\n    z-index: 1;\n    outline: 0 none;\n    border-radius: ").concat(dt("toggleswitch.border.radius"), ";\n}\n\n.p-toggleswitch-slider {\n    display: inline-block;\n    cursor: pointer;\n    width: 100%;\n    height: 100%;\n    border-width: ").concat(dt("toggleswitch.border.width"), ";\n    border-style: solid;\n    border-color: ").concat(dt("toggleswitch.border.color"), ";\n    background: ").concat(dt("toggleswitch.background"), ";\n    transition: background ").concat(dt("toggleswitch.transition.duration"), ", color ").concat(dt("toggleswitch.transition.duration"), ", border-color ").concat(dt("toggleswitch.transition.duration"), ", outline-color ").concat(dt("toggleswitch.transition.duration"), ", box-shadow ").concat(dt("toggleswitch.transition.duration"), ";\n    border-radius: ").concat(dt("toggleswitch.border.radius"), ";\n    outline-color: transparent;\n    box-shadow: ").concat(dt("toggleswitch.shadow"), ';\n}\n\n.p-toggleswitch-slider:before {\n    position: absolute;\n    content: "";\n    top: 50%;\n    background: ').concat(dt("toggleswitch.handle.background"), ";\n    width: ").concat(dt("toggleswitch.handle.size"), ";\n    height: ").concat(dt("toggleswitch.handle.size"), ";\n    left: ").concat(dt("toggleswitch.gap"), ";\n    margin-top: calc(-1 * calc(").concat(dt("toggleswitch.handle.size"), " / 2));\n    border-radius: ").concat(dt("toggleswitch.handle.border.radius"), ";\n    transition: background ").concat(dt("toggleswitch.transition.duration"), ", left ").concat(dt("toggleswitch.slide.duration"), ";\n}\n\n.p-toggleswitch.p-toggleswitch-checked .p-toggleswitch-slider {\n    background: ").concat(dt("toggleswitch.checked.background"), ";\n    border-color: ").concat(dt("toggleswitch.checked.border.color"), ";\n}\n\n.p-toggleswitch.p-toggleswitch-checked .p-toggleswitch-slider:before {\n    background: ").concat(dt("toggleswitch.handle.checked.background"), ";\n    left: calc(").concat(dt("toggleswitch.width"), " - calc(").concat(dt("toggleswitch.handle.size"), " + ").concat(dt("toggleswitch.gap"), "));\n}\n\n.p-toggleswitch:not(.p-disabled):has(.p-toggleswitch-input:hover) .p-toggleswitch-slider {\n    background: ").concat(dt("toggleswitch.hover.background"), ";\n    border-color: ").concat(dt("toggleswitch.hover.border.color"), ";\n}\n\n.p-toggleswitch:not(.p-disabled):has(.p-toggleswitch-input:hover) .p-toggleswitch-slider:before {\n    background: ").concat(dt("toggleswitch.handle.hover.background"), ";\n}\n\n.p-toggleswitch:not(.p-disabled):has(.p-toggleswitch-input:hover).p-toggleswitch-checked .p-toggleswitch-slider {\n    background: ").concat(dt("toggleswitch.checked.hover.background"), ";\n    border-color: ").concat(dt("toggleswitch.checked.hover.border.color"), ";\n}\n\n.p-toggleswitch:not(.p-disabled):has(.p-toggleswitch-input:hover).p-toggleswitch-checked .p-toggleswitch-slider:before {\n    background: ").concat(dt("toggleswitch.handle.checked.hover.background"), ";\n}\n\n.p-toggleswitch:not(.p-disabled):has(.p-toggleswitch-input:focus-visible) .p-toggleswitch-slider {\n    box-shadow: ").concat(dt("toggleswitch.focus.ring.shadow"), ";\n    outline: ").concat(dt("toggleswitch.focus.ring.width"), " ").concat(dt("toggleswitch.focus.ring.style"), " ").concat(dt("toggleswitch.focus.ring.color"), ";\n    outline-offset: ").concat(dt("toggleswitch.focus.ring.offset"), ";\n}\n\n.p-toggleswitch.p-invalid > .p-toggleswitch-slider {\n    border-color: ").concat(dt("toggleswitch.invalid.border.color"), ";\n}\n\n.p-toggleswitch.p-disabled {\n    opacity: 1;\n}\n\n.p-toggleswitch.p-disabled .p-toggleswitch-slider {\n    background: ").concat(dt("toggleswitch.disabled.background"), ";\n}\n\n.p-toggleswitch.p-disabled .p-toggleswitch-slider:before {\n    background: ").concat(dt("toggleswitch.handle.disabled.background"), ";\n}\n");
};
var inlineStyles = {
  root: {
    position: "relative"
  }
};
var classes = {
  root: function root(_ref2) {
    var instance = _ref2.instance, props = _ref2.props;
    return ["p-toggleswitch p-component", {
      "p-toggleswitch-checked": instance.checked,
      "p-disabled": props.disabled,
      "p-invalid": props.invalid
    }];
  },
  input: "p-toggleswitch-input",
  slider: "p-toggleswitch-slider"
};
var ToggleSwitchStyle = BaseStyle.extend({
  name: "toggleswitch",
  theme,
  classes,
  inlineStyles
});

// node_modules/primevue/toggleswitch/index.mjs
var script$1 = {
  name: "BaseToggleSwitch",
  "extends": script,
  props: {
    modelValue: {
      type: null,
      "default": false
    },
    trueValue: {
      type: null,
      "default": true
    },
    falseValue: {
      type: null,
      "default": false
    },
    invalid: {
      type: Boolean,
      "default": false
    },
    disabled: {
      type: Boolean,
      "default": false
    },
    readonly: {
      type: Boolean,
      "default": false
    },
    tabindex: {
      type: Number,
      "default": null
    },
    inputId: {
      type: String,
      "default": null
    },
    inputClass: {
      type: [String, Object],
      "default": null
    },
    inputStyle: {
      type: Object,
      "default": null
    },
    ariaLabelledby: {
      type: String,
      "default": null
    },
    ariaLabel: {
      type: String,
      "default": null
    }
  },
  style: ToggleSwitchStyle,
  provide: function provide() {
    return {
      $pcToggleSwitch: this,
      $parentInstance: this
    };
  }
};
var script2 = {
  name: "ToggleSwitch",
  "extends": script$1,
  inheritAttrs: false,
  emits: ["update:modelValue", "change", "focus", "blur"],
  methods: {
    getPTOptions: function getPTOptions(key) {
      var _ptm = key === "root" ? this.ptmi : this.ptm;
      return _ptm(key, {
        context: {
          checked: this.checked,
          disabled: this.disabled
        }
      });
    },
    onChange: function onChange(event) {
      if (!this.disabled && !this.readonly) {
        var newValue = this.checked ? this.falseValue : this.trueValue;
        this.$emit("update:modelValue", newValue);
        this.$emit("change", event);
      }
    },
    onFocus: function onFocus(event) {
      this.$emit("focus", event);
    },
    onBlur: function onBlur(event) {
      this.$emit("blur", event);
    }
  },
  computed: {
    checked: function checked() {
      return this.modelValue === this.trueValue;
    }
  }
};
var _hoisted_1 = ["data-p-checked", "data-p-disabled"];
var _hoisted_2 = ["id", "checked", "tabindex", "disabled", "readonly", "aria-checked", "aria-labelledby", "aria-label", "aria-invalid"];
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock("div", mergeProps({
    "class": _ctx.cx("root"),
    style: _ctx.sx("root")
  }, $options.getPTOptions("root"), {
    "data-p-checked": $options.checked,
    "data-p-disabled": _ctx.disabled
  }), [createBaseVNode("input", mergeProps({
    id: _ctx.inputId,
    type: "checkbox",
    role: "switch",
    "class": [_ctx.cx("input"), _ctx.inputClass],
    style: _ctx.inputStyle,
    checked: $options.checked,
    tabindex: _ctx.tabindex,
    disabled: _ctx.disabled,
    readonly: _ctx.readonly,
    "aria-checked": $options.checked,
    "aria-labelledby": _ctx.ariaLabelledby,
    "aria-label": _ctx.ariaLabel,
    "aria-invalid": _ctx.invalid || void 0,
    onFocus: _cache[0] || (_cache[0] = function() {
      return $options.onFocus && $options.onFocus.apply($options, arguments);
    }),
    onBlur: _cache[1] || (_cache[1] = function() {
      return $options.onBlur && $options.onBlur.apply($options, arguments);
    }),
    onChange: _cache[2] || (_cache[2] = function() {
      return $options.onChange && $options.onChange.apply($options, arguments);
    })
  }, $options.getPTOptions("input")), null, 16, _hoisted_2), createBaseVNode("span", mergeProps({
    "class": _ctx.cx("slider")
  }, $options.getPTOptions("slider")), null, 16)], 16, _hoisted_1);
}
script2.render = render;

export {
  script2 as script
};
//# sourceMappingURL=chunk-CEI6MPLZ.js.map
