<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $permissions = [
            'rol-listar',
            'rol-crear',
            'rol-editar',
            'rol-eliminar',
            'usuarios-listar',
            'usuarios-crear',
            'usuarios-editar',
            'usuarios-eliminar'
        ];

        $permissions2 = [
            'solicitudes_conductor-listar',
            'solicitudes_conductor-crear',
            'solicitudes_conductor-editar',
            'solicitudes_conductor-eliminar'
        ];

        $permissions3 = [
            'rutas-listar',
            'rutas-crear',
            'rutas-editar',
            'rutas-eliminar'
        ];

        $permissions4 = [
            'solicitudes_rutas-listar',
            'solicitudes_rutas-crear',
            'solicitudes_rutas-editar',
            'solicitudes_rutas-eliminar'
        ];
        
        $permissions5 = [
            'solicitar_viajes-listar',
            'solicitar_viajes-crear',
            'solicitar_viajes-editar',
            'solicitar_viajes-eliminar'
        ];

        $permissions6 = [
            'configuracion-sistema',
        ];

        $permissions7 = [
            'solicitudes_pasajero-listar',
            'solicitudes_pasajero-crear',
            'solicitudes_pasajero-editar',
            'solicitudes_pasajero-eliminar'
        ];

        foreach ($permissions7 as $permission) {
            Permission::create(['name' => $permission]);
        }
    }
}
