<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Estudiantes extends Model
{
    use HasFactory;

    protected $table = 'estudiante';

    protected $fillable = [
        'id_user',
        'nombre',
        'tipo_doc',
        'tipo_doc',
        'identificacion',
        'pdf_id',
        'direccion',
        'telefono',
        'eps',
        'certificado_eps',
        'foto_perfil',
        'isConductor',
        'puntaje',
        'estado'
    ];


    public function conductor()
    {
        return $this->hasOne(Conductores::class, 'id_estudiante', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'id_user', 'id');
    }


}