<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Calificaciones extends Model
{
    use HasFactory;

    protected $table = 'calificaciones';

    protected $fillable = [
        'id_evaluador',
        'id_evaluado',
        'id_ruta',
        'puntaje',
        'observaciones',
        'tipo_evaluado',
        'estado'
    ];

    // Relación para obtener el estudiante (si el evaluado es un pasajero)
    public function estudiante()
    {
        return $this->belongsTo(Estudiantes::class, 'id_evaluado');
    }

    public function ruta()
    {
        return $this->belongsTo(Rutas::class, 'id_ruta');
    }

}
