<?php

namespace App\Http\Controllers;

use App\Models\Conductores;
use App\Models\Estudiantes;
use Illuminate\Support\Facades\Request as RequestFacade;
use App\Models\Gastos;
use App\Models\Rutas;
use App\Models\SolicitudesRuta;
use App\Models\Vehiculos;
use Dotenv\Exception\ValidationException;
use Inertia\Inertia;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Carbon;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SolicitudesPasajeroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    function __construct()
    {
        $this->middleware('permission:solicitudes_pasajero-listar|solicitudes_pasajero-crear|solicitudes_pasajero-editar|solicitudes_pasajero-eliminar', ['only' => ['index', 'store']]);
        $this->middleware('permission:solicitudes_pasajero-crear', ['only' => ['create', 'store']]);
        $this->middleware('permission:solicitudes_pasajero-editar', ['only' => ['edit', 'update']]);
        $this->middleware('permission:solicitudes_pasajero-eliminar', ['only' => ['destroy']]);
    }

    public function index(Request $request)
    {
        $userAuth = Auth::user();

        // Obtener el estudiante logueado
        $estudiante = Estudiantes::select('id', 'nombre')->where('id_user', $userAuth->id)->first();

        // Obtener el estado de la solicitud desde la petición
        $estado = $request->input('estado', 'aprobado');

        // Consultar las solicitudes de viaje del estudiante con la información de la ruta y el vehículo
        $solicitudes = SolicitudesRuta::where('id_estudiante', $estudiante->id)
            ->when($estado, function ($query, $estado) {
                return $query->where('estado', $estado);
            })
            ->with([
                'rutas' => function ($query) {
                    $query->select('id', 'origen', 'destino', 'fecha_hora', 'id_vehiculo')
                        ->with([
                            'vehiculo:id,marca_vehiculo,linea_vehiculo,placa'
                        ]);
                }
            ])
            ->orderBy('created_at', 'desc')
            ->paginate(5)
            ->withQueryString();

        return Inertia::render('SolicitudesPasajero/Index', [
            'solicitudes' => $solicitudes,
            'filters' => RequestFacade::only(['estado'])
        ]);
    }


    public function edit(Request $request, $id)
    {
        $ruta = Rutas::with([
            'conductor:id,id_estudiante,puntaje',
            'conductor.estudiante:id,nombre,telefono',
            'vehiculo:id,placa,linea_vehiculo,marca_vehiculo,foto_vehiculo'
        ])->findOrFail($id);
    
        $api_key = env('API_RUTE_KEY');
        $api_route = env('API_RUTE');

        $baseUrl = url('/');
        $url_imagenes = $baseUrl . '/storage/';
    
        return Inertia::render('SolicitudesPasajero/Edit', [
            'ruta' => $ruta,
            'api_key' => $api_key,
            'api_route' => $api_route,
            'url_imagenes' => $url_imagenes
        ]);
    }
}
