<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Conductores;
use App\Models\Estudiantes;
use App\Models\Vehiculos;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\UploadedFile;
use Inertia\Inertia;

class SolicitarConductorController extends Controller
{
    public function edit($id)
    {
        // Buscar si el estudiante tiene una solicitud pendiente (estado = 0)
        $solicitudPendiente = Conductores::where('id_estudiante', $id)
                                ->where('estado', 0)
                                ->exists();

        // Si no tiene solicitud, continuar con la vista
        return Inertia::render('SolicitarSerConductor/Edit', compact('solicitudPendiente', 'id'));
    }
    /**
     * Editar informacion general del usuario
     */
    public function store(Request $request)
    {
        $request->validate([
            'licencia'  => 'required|string|max:15|min:5',
            'id_estudiante' => 'required',
            'licencia_pdf'  => 'required|mimes:pdf|max:5120',
            'vehiculos'  => 'required|array|min:1'
        ]);

        $userAuth = Auth::user();
        $user = $userAuth->id;
        
        $folderLicencia = 'conductores/' . $user;
        $extensionLicencia = $request->file('licencia_pdf')->getClientOriginalExtension();
        $fileNameLicencia = $request->input('licencia') . '.' . $extensionLicencia;
        $filePathLicencia = $request->file('licencia_pdf')->storeAs('uploads/' . $folderLicencia, $fileNameLicencia, 'public');

        $conductor = Conductores::create([
            'id_estudiante' => $request->id_estudiante,
            'licencia' => $request->licencia,
            'licencia_pdf' => $filePathLicencia,
            'estado' => 0
        ]);

        $folderConductor = 'conductores/' . $user;

        foreach ($request->vehiculos as $vehiculo) {
            // Verificar y guardar SOAT
            $soatPath = isset($vehiculo['soat']) && $vehiculo['soat'] instanceof UploadedFile 
                ? $vehiculo['soat']->storeAs("uploads/$folderConductor", 'soat_' . $vehiculo['placa'] . '.' . $vehiculo['soat']->getClientOriginalExtension(), 'public') 
                : null;
        
            // Verificar y guardar Técnico Mecánica
            $tecnicoMecanicaPath = isset($vehiculo['tecnico_mecanica']) && $vehiculo['tecnico_mecanica'] instanceof UploadedFile 
                ? $vehiculo['tecnico_mecanica']->storeAs("uploads/$folderConductor", 'tecnico_' . $vehiculo['placa'] . '.' . $vehiculo['tecnico_mecanica']->getClientOriginalExtension(), 'public') 
                : null;
        
            // Verificar y guardar Foto Vehículo
            $fotoVehiculoPath = isset($vehiculo['foto_vehiculo']) && $vehiculo['foto_vehiculo'] instanceof UploadedFile 
                ? $vehiculo['foto_vehiculo']->storeAs("uploads/$folderConductor", 'foto_' . $vehiculo['placa'] . '.' . $vehiculo['foto_vehiculo']->getClientOriginalExtension(), 'public') 
                : null;
        
            // Verificar y guardar Tarjeta de Propiedad
            $tarjetaPropiedadPath = isset($vehiculo['tarjeta_propiedad']) && $vehiculo['tarjeta_propiedad'] instanceof UploadedFile 
                ? $vehiculo['tarjeta_propiedad']->storeAs("uploads/$folderConductor", 'tarjeta_' . $vehiculo['placa'] . '.' . $vehiculo['tarjeta_propiedad']->getClientOriginalExtension(), 'public') 
                : null;
        
            // Guardar Vehículo en la Base de Datos
            Vehiculos::create([
                'id_conductor' => $conductor->id,
                'soat' => $soatPath,
                'fecha_v_soat' => $vehiculo['fecha_v_soat'] ?? null,
                'tecnico_mecanica' => $tecnicoMecanicaPath,
                'fecha_v_mecanica' => $vehiculo['fecha_v_mecanica'] ?? null,
                'foto_vehiculo' => $fotoVehiculoPath,
                'modelo_vehiculo' => $vehiculo['modelo'],
                'marca_vehiculo' => $vehiculo['marca'],
                'linea_vehiculo' => $vehiculo['linea'],
                'tarjeta_propiedad' => $tarjetaPropiedadPath,
                'placa' => $vehiculo['placa'],
                'estado' => 0
            ]);
        }

        return to_route('dashboard');
    }
}
