<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Estudiantes;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Storage;

class EstudianteController extends Controller
{
    /**
     * Editar informacion general del usuario
     */
    public function update(Request $request, $id): RedirectResponse
    {
        $request->validate([
            'nombre' => 'required|string|max:255',
            'direccion' => 'required|string|max:255',
            'telefono' => 'required|numeric',
            'eps' => 'required|string|max:255',
        ]);

        $userAuth = Auth::user();

        $estudiante = Estudiantes::find($id);
        $estudiante->nombre = $request->input('nombre');
        $estudiante->direccion = $request->input('direccion');
        $estudiante->telefono = $request->input('telefono');
        $estudiante->eps = $request->input('eps');
        
        if ($request->hasFile('certificado_eps')) {
            $request->validate([
                'certificado_eps' => 'required|mimes:pdf|max:5120',
            ]);

            $user = $userAuth->id;
            $folder = 'estudiantes/' . $user;

            $extensionEPS = $request->file('certificado_eps')->getClientOriginalExtension();
            $fileNameEPS = 'Certificado_eps.' . $extensionEPS;
            $filePathEPS = $request->file('certificado_eps')->storeAs('uploads/' . $folder, $fileNameEPS, 'public');

            $request->merge([
                'certificado_eps' => $filePathEPS,
            ]);

             // Eliminar el archivo antiguo si existe
             if ($estudiante->certificado_eps) {
                Storage::delete('uploads/' . $folder . '/' . $estudiante->certificado_eps);
            }

            $estudiante->certificado_eps = $filePathEPS;
        }

        if ($request->hasFile('foto_perfil')) {
            $request->validate([
                'foto_perfil' => 'required|mimes:jpeg,jpg,png|max:5120',
            ]);

            $user = $userAuth->id;
            $folder = 'estudiantes/' . $user;

            $extensionPerfil = $request->file('foto_perfil')->getClientOriginalExtension();
            $fileNamePerfil = 'perfil.' . $extensionPerfil;
            $filePathPerfil = $request->file('foto_perfil')->storeAs('uploads/' . $folder, $fileNamePerfil, 'public');

            $request->merge([
                'foto_perfil' => $filePathPerfil,
            ]);

             // Eliminar el archivo antiguo si existe
             if ($estudiante->foto_perfil) {
                Storage::delete('uploads/' . $folder . '/' . $estudiante->foto_perfil);
            }

            $estudiante->foto_perfil = $filePathPerfil;
        }

        $estudiante->save();
        
        Cache::forget("estudiante_" . $request->user()->id);

        return Redirect::route('profile.edit');
    }
}
