import './bootstrap';
import '../css/app.css';

import { createApp, h } from 'vue';
import VueSweetalert2 from 'vue-sweetalert2';
import 'sweetalert2/dist/sweetalert2.min.css';
// theme
import Aura from '@primevue/themes/aura';
import { createInertiaApp } from '@inertiajs/vue3';
import { resolvePageComponent } from 'laravel-vite-plugin/inertia-helpers';
import { ZiggyVue } from '../../vendor/tightenco/ziggy/dist/vue.m';
import PrimeVue from 'primevue/config';
import { definePreset } from '@primevue/themes';
import Traduccion from '../../public/traduccion.json';
import ToastService from 'primevue/toastservice';
import ConfirmationService from 'primevue/confirmationservice';
import Tooltip from 'primevue/tooltip';
import axios from "axios";

axios.interceptors.request.use((config) => {
    window.dispatchEvent(new Event("loading:start"));
    return config;
});

axios.interceptors.response.use(
    (response) => {
        window.dispatchEvent(new Event("loading:finish"));
        return response;
    },
    (error) => {
        window.dispatchEvent(new Event("loading:finish"));
        return Promise.reject(error);
    }
);


const Noir = definePreset(Aura, {
    semantic: {
        primary: {
            50: '{purple.50}',
            100: '{purple.100}',
            200: '{purple.200}',
            300: '{purple.300}',
            400: '{purple.400}',
            500: '{purple.500}',
            600: '{purple.600}',
            700: '{purple.700}',
            800: '{purple.800}',
            900: '{purple.900}',
            950: '{purple.950}'
        },
        colorScheme: {
            light: {
                primary: {
                    color: '{purple.950}',
                    inverseColor: '#ffffff',
                    hoverColor: '{purple.900}',
                    activeColor: '{purple.800}'
                },
                highlight: {
                    background: '{purple.950}',
                    focusBackground: '{purple.700}',
                    color: '#ffffff',
                    focusColor: '#ffffff'
                }
            },
            dark: {
                primary: {
                    color: '{purple.50}',
                    inverseColor: '{purple.950}',
                    hoverColor: '{purple.100}',
                    activeColor: '{purple.200}'
                },
                highlight: {
                    background: 'rgba(250, 250, 250, .16)',
                    focusBackground: 'rgba(250, 250, 250, .24)',
                    color: 'rgba(255,255,255,.87)',
                    focusColor: 'rgba(255,255,255,.87)'
                }
            }
        }
    }
});

const appName = import.meta.env.VITE_APP_NAME || 'Laravel';

createInertiaApp({
    title: (title) => `${title} - ${appName}`,
    resolve: (name) => resolvePageComponent(`./Pages/${name}.vue`, import.meta.glob('./Pages/**/*.vue')),
    setup({ el, App, props, plugin }) {
        return createApp({ render: () => h(App, props) })
            .use(plugin)
            .use(VueSweetalert2)
            .use(PrimeVue, {
                theme: {
                    preset: Noir,
                    options: {
                        darkModeSelector: '.my-app-dar',
                    },
                    cssLayer: {
                        name: 'primevue',
                        order: 'tailwind-base, primevue, tailwind-utilities'
                    }
                },
                locale: Traduccion
            })
            .use(ZiggyVue)
            .use(ToastService)
            .directive('tooltip', Tooltip)
            .use(ConfirmationService)
            .mount(el);
    },
    progress: {
        color: '#0ea5e9',
        // Whether the NProgress spinner will be shown...
        showSpinner: true,
    },
});
