import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-rating {\n    position: relative;\n    display: flex;\n    align-items: center;\n    gap: ".concat(dt('rating.gap'), ";\n}\n\n.p-rating-option {\n    display: inline-flex;\n    align-items: center;\n    cursor: pointer;\n    outline-color: transparent;\n    border-radius: 50%;\n    cursor: pointer;\n    transition: background ").concat(dt('rating.transition.duration'), ", color ").concat(dt('rating.transition.duration'), ", border-color ").concat(dt('rating.transition.duration'), ", outline-color ").concat(dt('rating.transition.duration'), ", box-shadow ").concat(dt('rating.transition.duration'), ";\n}\n\n.p-rating-option.p-focus-visible {\n    box-shadow: ").concat(dt('focus.ring.shadow'), ";\n    outline: ").concat(dt('focus.ring.width'), " ").concat(dt('focus.ring.style'), " ").concat(dt('focus.ring.color'), ";\n    outline-offset: ").concat(dt('focus.ring.offset'), ";\n}\n\n.p-rating-icon {\n    color: ").concat(dt('rating.icon.color'), ";\n    transition: background ").concat(dt('rating.transition.duration'), ", color ").concat(dt('rating.transition.duration'), ", border-color ").concat(dt('rating.transition.duration'), ", outline-color ").concat(dt('rating.transition.duration'), ", box-shadow ").concat(dt('rating.transition.duration'), ";\n    font-size: ").concat(dt('rating.icon.size'), ";\n    width: ").concat(dt('rating.icon.size'), ";\n    height: ").concat(dt('rating.icon.size'), ";\n}\n\n.p-rating:not(.p-disabled):not(.p-readonly) .p-rating-option:hover .p-rating-icon {\n    color: ").concat(dt('rating.icon.hover.color'), ";\n}\n\n.p-rating-option-active .p-rating-icon {\n    color: ").concat(dt('rating.icon.active.color'), ";\n}\n");
};
var classes = {
  root: function root(_ref2) {
    var props = _ref2.props;
    return ['p-rating', {
      'p-readonly': props.readonly,
      'p-disabled': props.disabled
    }];
  },
  option: function option(_ref3) {
    var instance = _ref3.instance,
      props = _ref3.props,
      value = _ref3.value;
    return ['p-rating-option', {
      'p-rating-option-active': value <= props.modelValue,
      'p-focus-visible': value === instance.focusedOptionIndex && instance.isFocusVisibleItem
    }];
  },
  onIcon: 'p-rating-icon p-rating-on-icon',
  offIcon: 'p-rating-icon p-rating-off-icon'
};
var RatingStyle = BaseStyle.extend({
  name: 'rating',
  theme: theme,
  classes: classes
});

export { RatingStyle as default };
//# sourceMappingURL=index.mjs.map
