import BaseStyle from '@primevue/core/base/style';

var theme = function theme(_ref) {
  var dt = _ref.dt;
  return "\n.p-accordionpanel {\n    display: flex;\n    flex-direction: column;\n    border-style: solid;\n    border-width: ".concat(dt('accordion.panel.border.width'), ";\n    border-color: ").concat(dt('accordion.panel.border.color'), ";\n}\n\n.p-accordionheader {\n    all: unset;\n    cursor: pointer;\n    display: flex;\n    align-items: center;\n    justify-content: space-between;\n    padding: ").concat(dt('accordion.header.padding'), ";\n    color: ").concat(dt('accordion.header.color'), ";\n    background: ").concat(dt('accordion.header.background'), ";\n    border-style: solid;\n    border-width: ").concat(dt('accordion.header.border.width'), ";\n    border-color: ").concat(dt('accordion.header.border.color'), ";\n    font-weight: ").concat(dt('accordion.header.font.weight'), ";\n    border-radius: ").concat(dt('accordion.header.border.radius'), ";\n    transition: background ").concat(dt('accordion.transition.duration'), "; color ").concat(dt('accordion.transition.duration'), "color ").concat(dt('accordion.transition.duration'), ", outline-color ").concat(dt('accordion.transition.duration'), ", box-shadow ").concat(dt('accordion.transition.duration'), ";\n    outline-color: transparent;\n}\n\n.p-accordionpanel:first-child > .p-accordionheader {\n    border-width: ").concat(dt('accordion.header.first.border.width'), ";\n    border-top-left-radius: ").concat(dt('accordion.header.first.top.border.radius'), ";\n    border-top-right-radius: ").concat(dt('accordion.header.first.top.border.radius'), ";\n}\n\n.p-accordionpanel:last-child > .p-accordionheader {\n    border-bottom-left-radius: ").concat(dt('accordion.header.last.bottom.border.radius'), ";\n    border-bottom-right-radius: ").concat(dt('accordion.header.last.bottom.border.radius'), ";\n}\n\n.p-accordionpanel:last-child.p-accordionpanel-active > .p-accordionheader {\n    border-bottom-left-radius: ").concat(dt('accordion.header.last.active.bottom.border.radius'), ";\n    border-bottom-right-radius:").concat(dt('accordion.header.last.active.bottom.border.radius'), ";\n}\n\n.p-accordionheader-toggle-icon {\n    color: ").concat(dt('accordion.header.toggle.icon.color'), ";\n}\n\n.p-accordionpanel:not(.p-disabled) .p-accordionheader:focus-visible {\n    box-shadow: ").concat(dt('accordion.header.focus.ring.shadow'), ";\n    outline: ").concat(dt('accordion.header.focus.ring.width'), " ").concat(dt('accordion.header.focus.ring.style'), " ").concat(dt('accordion.header.focus.ring.color'), ";\n    outline-offset: ").concat(dt('accordion.header.focus.ring.offset'), ";\n}\n\n.p-accordionpanel:not(.p-accordionpanel-active):not(.p-disabled) > .p-accordionheader:hover {\n    background: ").concat(dt('accordion.header.hover.background'), ";\n    color: ").concat(dt('accordion.header.hover.color'), "\n}\n\n.p-accordionpanel:not(.p-accordionpanel-active):not(.p-disabled) .p-accordionheader:hover .p-accordionheader-toggle-icon {\n    color: ").concat(dt('accordion.header.toggle.icon.hover.color'), ";\n}\n\n.p-accordionpanel:not(.p-disabled).p-accordionpanel-active > .p-accordionheader {\n    background: ").concat(dt('accordion.header.active.background'), ";\n    color: ").concat(dt('accordion.header.active.color'), "\n}\n\n.p-accordionpanel:not(.p-disabled).p-accordionpanel-active > .p-accordionheader .p-accordionheader-toggle-icon {\n    color: ").concat(dt('accordion.header.toggle.icon.active.color'), ";\n}\n\n.p-accordionpanel:not(.p-disabled).p-accordionpanel-active > .p-accordionheader:hover  {\n    background: ").concat(dt('accordion.header.active.hover.background'), ";\n    color: ").concat(dt('accordion.header.active.hover.color'), "\n}\n\n.p-accordionpanel:not(.p-disabled).p-accordionpanel-active > .p-accordionheader:hover  .p-accordionheader-toggle-icon {\n    color: ").concat(dt('accordion.header.toggle.icon.active.hover.color'), ";\n}\n\n.p-accordioncontent-content {\n    border-style: solid;\n    border-width: ").concat(dt('accordion.content.border.width'), ";\n    border-color: ").concat(dt('accordion.content.border.color'), ";\n    background-color: ").concat(dt('accordion.content.background'), ";\n    color: ").concat(dt('accordion.content.color'), ";\n    padding: ").concat(dt('accordion.content.padding'), "\n}\n");
};
var classes = {
  root: 'p-accordion p-component'
};
var AccordionStyle = BaseStyle.extend({
  name: 'accordion',
  theme: theme,
  classes: classes
});

export { AccordionStyle as default };
//# sourceMappingURL=index.mjs.map
