import "./chunk-FLSNA7AK.js";
import {
  computed,
  createBlock,
  defineComponent,
  guardReactiveProps,
  normalizeProps,
  normalizeStyle,
  onMounted,
  openBlock,
  ref,
  renderSlot,
  resolveDynamicComponent,
  shallowRef,
  toRef,
  watch,
  withCtx
} from "./chunk-DIASZOHW.js";
import "./chunk-WXXH56N5.js";

// node_modules/vue-collapsed/dist/index.mjs
var R = "--vc-auto-duration";
var P = `height var(${R}) cubic-bezier(0.33, 1, 0.68, 1)`;
var p = { padding: 0 };
var V = 300;
var Y = {
  position: "absolute",
  width: "1px",
  height: "1px",
  padding: "0",
  margin: "-1px",
  overflow: "hidden",
  clip: "rect(0, 0, 0, 0)",
  whiteSpace: "nowrap",
  border: "0"
};
function C(a) {
  return a.value ? parseFloat(getComputedStyle(a.value).height) : 0;
}
function D(a) {
  if (!a.value)
    return {};
  const { transition: n } = getComputedStyle(a.value);
  return n === "all 0s ease 0s" || n === "all" ? { transition: P } : { transition: n };
}
function b(a) {
  if (!a.value)
    return true;
  const { transition: n } = getComputedStyle(a.value);
  return typeof window.requestAnimationFrame > "u" || window.matchMedia("(prefers-reduced-motion: reduce)").matches || n.includes("none") || n.includes("height 0s");
}
function K(a = 0) {
  if (a === 0)
    return 0;
  const n = a / 36, o = Math.round((4 + 15 * n ** 0.25 + n / 5) * 10);
  return Number.isFinite(o) ? o : 0;
}
var J = defineComponent({
  inheritAttrs: true,
  __name: "Collapse",
  props: {
    when: { type: Boolean },
    baseHeight: { default: 0 },
    as: { default: "div" }
  },
  emits: ["collapse", "expand", "collapsed", "expanded"],
  setup(a, { emit: n }) {
    const o = a, u = n, i = toRef(o, "when"), l = toRef(o, "baseHeight"), h = computed(() => ({ overflow: "hidden", height: `${l.value}px` })), v = computed(() => ({
      ...p,
      ...l.value === 0 ? { display: "none" } : h.value
    })), t = ref(null), f = ref(i.value ? "expanded" : "collapsed"), c = (e) => f.value = e;
    function N() {
      return i.value ? p : l.value === 0 ? Y : v.value;
    }
    const g = shallowRef(N()), s = (e) => g.value = e, r = (e) => s({ ...g.value, ...e }), w = ref(V), T = (e) => w.value = e, A = computed(() => ({ [R]: `${w.value}ms` }));
    let d = NaN;
    function m() {
      s(p), c("expanded"), u("expanded");
    }
    function y() {
      s(v.value), c("collapsed"), u("collapsed");
    }
    onMounted(() => {
      if (!t.value)
        return;
      const e = K(t.value.scrollHeight - l.value);
      e > 0 && T(e), !i.value && l.value === 0 && s(v.value);
    }), watch(i, (e) => {
      if (t.value)
        if (d = NaN, e) {
          if (b(t))
            return m();
          c("expanding"), u("expand"), s({
            ...p,
            ...h.value,
            ...A.value
          }), requestAnimationFrame(() => {
            if (t.value.scrollHeight === 0)
              return m();
            d = t.value.scrollHeight, r({
              ...D(t),
              height: `${d}px`,
              willChange: "height"
            });
          });
        } else {
          if (b(t) || (c("collapsing"), u("collapse"), r({
            ...A.value,
            height: `${t.value.scrollHeight}px`
          }), t.value.scrollHeight === 0))
            return y();
          requestAnimationFrame(() => {
            r({
              ...h.value,
              ...D(t),
              willChange: "height"
            });
          });
        }
    }), watch(l, (e) => {
      i.value || (e > 0 ? r({ display: void 0, height: `${e}px` }) : r({ display: "none" }));
    });
    function F(e) {
      e.target && e.target === t.value && e.propertyName === "height" && (i.value ? Math.abs(t.value.scrollHeight - C(t)) < 1 ? m() : d < t.value.scrollHeight && r({
        height: `${t.value.scrollHeight}px`
      }) : Math.abs(l.value - C(t)) < 1 && y());
    }
    return (e, j) => (openBlock(), createBlock(resolveDynamicComponent(o.as), {
      ref_key: "collapseRef",
      ref: t,
      style: normalizeStyle(g.value),
      onTransitionend: F,
      "data-collapse": f.value
    }, {
      default: withCtx(() => [
        renderSlot(e.$slots, "default", normalizeProps(guardReactiveProps({ state: f.value })))
      ]),
      _: 3
    }, 40, ["style", "data-collapse"]));
  }
});
export {
  J as Collapse
};
//# sourceMappingURL=vue-collapsed.js.map
