<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SolicitudesRuta extends Model
{
    use HasFactory;

    protected $table = 'solicitudes_ruta';

    protected $fillable = [
        'id_ruta',
        'id_estudiante',
        'observaciones',
        'estado'
    ];

    public function rutas()
    {
        return $this->hasOne(Rutas::class, 'id', 'id_ruta');
    }

    public function estudiante()
    {
        return $this->hasOne(Estudiantes::class, 'id', 'id_estudiante');
    }
}
