<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Rutas extends Model
{
    use HasFactory;

    protected $table = 'rutas';

    protected $fillable = [
        'id_conductor',
        'id_vehiculo',
        'origen',
        'destino',
        'fecha_hora',
        'puestos_disponibles',
        'lat_origen',
        'long_origen',
        'lat_destino',
        'long_destino',
        'kilometros',
        'indicaciones',
        'estado'
    ];

    public function vehiculo()
    {
        return $this->belongsTo(Vehiculos::class, 'id_vehiculo', 'id');
    }

    public function conductor()
    {
        return $this->belongsTo(Conductores::class, 'id_conductor', 'id');
    }


    public function solicitud_rutas()
    {
        return $this->hasMany(SolicitudesRuta::class, 'id', 'id_ruta');
    }

    public function calificacionesPendientes()
    {
        return $this->hasMany(Calificaciones::class, 'id_ruta')
            ->where('estado', 0)
            ->where('tipo_evaluado', 'Pasajero');
    }


}
