<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Conductores extends Model
{
    use HasFactory;

    protected $table = 'conductor';

    protected $fillable = [
        'id_estudiante',
        'licencia',
        'licencia_pdf',
        'estado'
    ];

    public function vehiculos()
    {
        return $this->hasMany(Vehiculos::class, 'id_conductor', 'id');
    }

    public function estudiante()
    {
        return $this->belongsTo(Estudiantes::class, 'id_estudiante', 'id');
    }
}
