<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SolicitudConductorMail extends Mailable
{
    use Queueable, SerializesModels;

    public $estado;
    public $usuario;
    public $comentario;

    public function __construct($estado, $usuario, $comentario = null)
    {
        $this->estado = $estado;
        $this->usuario = $usuario;
        $this->comentario = $comentario;
    }

    public function build()
    {
        return $this->from(config('mail.from.address'), config('mail.from.name'))
                    ->subject('Estado de tu solicitud de conductor')
                    ->view('emails.solicitud_conductor')
                    ->with([
                        'estado' => $this->estado,
                        'usuario' => $this->usuario,
                        'comentario' => $this->comentario
                    ]);
    }
}