<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CancelacionRutasMail extends Mailable
{
    use Queueable, SerializesModels;

    public $estado;
    public $origen;
    public $destino;
    public $nombre;

    public function __construct($estado, $origen, $destino, $nombre)
    {
        $this->estado = $estado;
        $this->origen = $origen;
        $this->destino = $destino;
        $this->nombre = $nombre;
    }


    public function build()
    {
        return $this->from(config('mail.from.address'), config('mail.from.name'))
                    ->subject('Estado de tu solicitud de ruta')
                    ->view('emails.cancelacion_ruta')
                    ->with([
                        'estado' => $this->estado,
                        'origen' => $this->origen,
                        'destino' => $this->destino,
                        'nombre' => $this->nombre,
                    ]);
    }
}
