<?php

namespace App\Http\Middleware;

use App\Models\Estudiantes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Inertia\Middleware;

class HandleInertiaRequests extends Middleware
{
    /**
     * The root template that is loaded on the first page visit.
     *
     * @var string
     */
    protected $rootView = 'app';

    /**
     * Determine the current asset version.
     *
     * @param \Illuminate\Http\Request $request
     * @return string|null
     */
    public function version(Request $request)
    {
        return parent::version($request);
    }

    /**
     * Define the props that are shared by default.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function share(Request $request)
    {
        return array_merge(parent::share($request), [
            'auth' => [
                'user' => $request->user()
            ],
            'estudiante' => auth()->check() 
            ? Cache::remember("estudiante_{$request->user()->id}", 86400, function () use ($request) {
                return Estudiantes::select('id', 'foto_perfil', 'nombre', 'direccion', 'telefono', 'eps', 'isConductor', 'certificado_eps')
                    ->where('id_user', $request->user()->id)
                    ->first();
            }) 
            : null,
            'base_url' => url('/') . '/storage/',
            'flash' => function () use ($request) {
                return [
                    'success' => $request->session()->get('success'),
                ];
            },
            'user.roles' => $request->user() ? $request->user()->roles->pluck('name') : [],
            'user.permissions' => $request->user() ? $request->user()->getPermissionsViaRoles()->pluck('name') : [],
            'showingMobileMenu' => false,
        ]);
    }
}
