<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckUserRole
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();

        // Verifica si el usuario autenticado NO tiene roles
        if ($user && $user->roles()->count() === 0) {
            return redirect()->route('asignar.rol');
        }

        return $next($request);
    }
}