<?php

namespace App\Http\Controllers;

use App\Models\Conductores;
use App\Models\Estudiantes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Role;
use App\Models\Vehiculos;
use Illuminate\Http\UploadedFile;

class RoleAssignmentController extends Controller
{
    public function form()
    {
        return inertia('AsignarRol'); // Vista de Inertia donde el usuario elige su rol
    }

    public function assignRole(Request $request)
    {
        $rules = [
            'role_id' => 'required',
            'nombre' => 'required|string|max:255',
            'tipo_identificacion' => 'required|string|max:255',
            'identificacion' => 'required|string|max:15|min:5',
            'archivo_id' => 'required|mimes:pdf|max:5120',
            'direccion' => 'required|string|max:250',
            'celular' => 'required|string|max:15',
            'eps' => 'required|string|max:255',
            'certificado_eps' => 'required|mimes:pdf|max:5120',
            'foto_perfil' => 'required|mimes:jpeg,jpg,png|max:5120',
        ];

        if ($request->role_id == 'conductor') {
            $rules['licencia'] = 'required|string|max:15|min:5';
            $rules['licencia_pdf'] = 'required|mimes:pdf|max:5120';
            $rules['vehiculos'] = 'required|array|min:1';
        }

        $request->validate($rules);

        $userAuth = Auth::user();

        if($request->role_id == 'conductor') {
            $isConductor = 1;
        }else{
            $isConductor = 0;
        }

        $estudianteValidacion = Estudiantes::where('identificacion', $request->identificacion)->first();

        if($estudianteValidacion){
            return back()->withErrors(['identificacion' => 'Ya existe un estudiante con esta identificación.']);
        }

        $user = $userAuth->id;
        $folder = 'estudiantes/' . $user;

        $extension = $request->file('archivo_id')->getClientOriginalExtension();
        $fileName = $request->input('identificacion') . '.' . $extension;
        $filePathId = $request->file('archivo_id')->storeAs('uploads/' . $folder, $fileName, 'public');

        $extensionEPS = $request->file('certificado_eps')->getClientOriginalExtension();
        $fileNameEPS = 'Certificado_eps.' . $extensionEPS;
        $filePathEPS = $request->file('certificado_eps')->storeAs('uploads/' . $folder, $fileNameEPS, 'public');

        $extensionPerfil = $request->file('foto_perfil')->getClientOriginalExtension();
        $fileNamePerfil = 'perfil.' . $extensionPerfil;
        $filePathPerfil = $request->file('foto_perfil')->storeAs('uploads/' . $folder, $fileNamePerfil, 'public');

        $estudiante = Estudiantes::create([
            'id_user' => $user,
            'nombre' => $request->nombre,
            'tipo_doc' => $request->tipo_identificacion,
            'identificacion' => $request->identificacion,
            'pdf_id' => $filePathId,
            'direccion' => $request->direccion,
            'telefono' => $request->celular,
            'eps' => $request->eps,
            'certificado_eps' => $filePathEPS,
            'foto_perfil' => $filePathPerfil,
            'isConductor' => $isConductor,
            'estado' => 1
        ]);

        $userAuth->roles()->attach(5);

        if($request->role_id == 'conductor') {
            $folderLicencia = 'conductores/' . $user;
            $extensionLicencia = $request->file('licencia_pdf')->getClientOriginalExtension();
            $fileNameLicencia = $request->input('licencia') . '.' . $extensionLicencia;
            $filePathLicencia = $request->file('licencia_pdf')->storeAs('uploads/' . $folderLicencia, $fileNameLicencia, 'public');

            $conductor = Conductores::create([
                'id_estudiante' => $estudiante->id,
                'licencia' => $request->licencia,
                'licencia_pdf' => $filePathLicencia,
                'estado' => 0
            ]);

            $folderConductor = 'conductores/' . $user;

            foreach ($request->vehiculos as $vehiculo) {
                // Verificar y guardar SOAT
                $soatPath = isset($vehiculo['soat']) && $vehiculo['soat'] instanceof UploadedFile 
                    ? $vehiculo['soat']->storeAs("uploads/$folderConductor", 'soat_' . $vehiculo['placa'] . '.' . $vehiculo['soat']->getClientOriginalExtension(), 'public') 
                    : null;
            
                // Verificar y guardar Técnico Mecánica
                $tecnicoMecanicaPath = isset($vehiculo['tecnico_mecanica']) && $vehiculo['tecnico_mecanica'] instanceof UploadedFile 
                    ? $vehiculo['tecnico_mecanica']->storeAs("uploads/$folderConductor", 'tecnico_' . $vehiculo['placa'] . '.' . $vehiculo['tecnico_mecanica']->getClientOriginalExtension(), 'public') 
                    : null;
            
                // Verificar y guardar Foto Vehículo
                $fotoVehiculoPath = isset($vehiculo['foto_vehiculo']) && $vehiculo['foto_vehiculo'] instanceof UploadedFile 
                    ? $vehiculo['foto_vehiculo']->storeAs("uploads/$folderConductor", 'foto_' . $vehiculo['placa'] . '.' . $vehiculo['foto_vehiculo']->getClientOriginalExtension(), 'public') 
                    : null;
            
                // Verificar y guardar Tarjeta de Propiedad
                $tarjetaPropiedadPath = isset($vehiculo['tarjeta_propiedad']) && $vehiculo['tarjeta_propiedad'] instanceof UploadedFile 
                    ? $vehiculo['tarjeta_propiedad']->storeAs("uploads/$folderConductor", 'tarjeta_' . $vehiculo['placa'] . '.' . $vehiculo['tarjeta_propiedad']->getClientOriginalExtension(), 'public') 
                    : null;
            
                // Guardar Vehículo en la Base de Datos
                Vehiculos::create([
                    'id_conductor' => $conductor->id,
                    'soat' => $soatPath,
                    'fecha_v_soat' => $vehiculo['fecha_v_soat'] ?? null,
                    'tecnico_mecanica' => $tecnicoMecanicaPath,
                    'fecha_v_mecanica' => $vehiculo['fecha_v_mecanica'] ?? null,
                    'foto_vehiculo' => $fotoVehiculoPath,
                    'modelo_vehiculo' => $vehiculo['modelo'],
                    'marca_vehiculo' => $vehiculo['marca'],
                    'linea_vehiculo' => $vehiculo['linea'],
                    'tarjeta_propiedad' => $tarjetaPropiedadPath,
                    'placa' => $vehiculo['placa'],
                    'estado' => 0
                ]);
            }            


        }

        return redirect()->route('dashboard')->with('success', 'Rol asignado correctamente.');
    }
}